/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.selftests;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import java.security.PublicKey;
import java.util.Locale;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.mozilla.jss.crypto.X509Certificate;

public class TPSPresence
extends SelfTest {
    public static final String PROP_TPS_SUB_ID = "TpsSubId";
    private String tpsSubId = null;

    public void initSelfTest(SelfTestSubsystem subsystem, String instanceName, ConfigStore parameters) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        super.initSelfTest(subsystem, instanceName, parameters);
        try {
            this.tpsSubId = this.mConfig.getString(PROP_TPS_SUB_ID);
            if (this.tpsSubId == null) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".TpsSubId"}));
                throw new EMissingSelfTestException(PROP_TPS_SUB_ID);
            }
            this.tpsSubId = this.tpsSubId.trim();
        }
        catch (EBaseException e) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_NAME", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".TpsSubId"}));
            throw new EMissingSelfTestException(this.mPrefix, PROP_TPS_SUB_ID, null);
        }
    }

    public void startupSelfTest() throws ESelfTestException {
    }

    public void shutdownSelfTest() {
    }

    public String getSelfTestName() {
        return super.getSelfTestName();
    }

    public ConfigStore getSelfTestConfigStore() {
        return super.getSelfTestConfigStore();
    }

    public String getSelfTestDescription(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_SELFTESTS_TPS_PRESENCE_DESCRIPTION", (String[])new String[0]);
    }

    public void runSelfTest(LogEventListener logger) throws Exception {
        X509Certificate tpsCert;
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem(this.tpsSubId);
        if (tps == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_NOT_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        try {
            tpsCert = tps.getSubsystemCert();
        }
        catch (Exception e) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_NOT_INITIALIZED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw e;
        }
        if (tpsCert == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_NOT_INITIALIZED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        PublicKey tpsPubKey = tpsCert.getPublicKey();
        if (tpsPubKey == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_CORRUPT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
        this.mSelfTestSubsystem.log(logger, logMessage);
    }
}

