package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;

import junit.framework.TestCase;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyPairGenerator;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumSigner;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class CrystalsDilithiumTest
    extends TestCase
{
    /*
count = 0
seed = 061550234D158C5EC95595FE04EF7A25767F2E24CC2BC479D09D86DC9ABCFDE7056A8C266F9EF97ED08541DBD2E1FFA1
mlen = 33
msg = D81C4D8D734FCBFBEADE3D3F8A039FAA2A2C9957E835AD55B22E75BF57BB556AC8
pk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
sk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
smlen = 3326
sm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
    */
    public void testDilithium()
    {
        String seed = "061550234D158C5EC95595FE04EF7A25767F2E24CC2BC479D09D86DC9ABCFDE7056A8C266F9EF97ED08541DBD2E1FFA1";
        String pk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
        String sk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

        NISTSecureRandom random = new NISTSecureRandom(Hex.decode(seed), null);

        DilithiumKeyPairGenerator keyGen = new DilithiumKeyPairGenerator();

        keyGen.init(new DilithiumKeyGenerationParameters(random, DilithiumParameters.dilithium3));

        AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();

        assertTrue(Arrays.areEqual(Hex.decode(sk), ((DilithiumPrivateKeyParameters)keyPair.getPrivate()).getEncoded()));
        DilithiumPublicKeyParameters dPub = (DilithiumPublicKeyParameters)keyPair.getPublic();
        assertTrue(Arrays.areEqual(Hex.decode(pk), dPub.getEncoded()));
    }

    public void testRNG()
    {
        String temp = "061550234D158C5EC95595FE04EF7A25767F2E24CC2BC479D09D86DC9ABCFDE7056A8C266F9EF97ED08541DBD2E1FFA1";
        byte[] seed = Hex.decode(temp);

        NISTSecureRandom r = new NISTSecureRandom(seed, null);

        String testBytesString = "7C9935A0B07694AA0C6D10E4DB6B1ADD2FD81A25CCB148032DCD739936737F2D";
        byte[] testBytes = Hex.decode(testBytesString);

        byte[] randBytes = new byte[testBytes.length];
        r.nextBytes(randBytes);

        assertTrue(Arrays.areEqual(randBytes, testBytes));
    }

    public void testVectors()
        throws Exception
    {
        String[] files = new String[]{
            "PQCsignKAT_Dilithium2.rsp",
            "PQCsignKAT_Dilithium3.rsp",
            "PQCsignKAT_Dilithium5.rsp",
        };

        DilithiumParameters[] parameters = new DilithiumParameters[]{
            DilithiumParameters.dilithium2,
            DilithiumParameters.dilithium3,
            DilithiumParameters.dilithium5,
        };

        TestSampler sampler = new TestSampler();
        for (int fileindex = 0; fileindex < files.length; fileindex++)
        {
            String name = files[fileindex];
            System.out.println("testing: " + name);
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/dilithium", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null)
            {
                line = line.trim();

                if (line.startsWith("#"))
                {
                    continue;
                }
                if (line.length() == 0)
                {
                    if (buf.size() > 0)
                    {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count))
                        {
                            continue;
                        }
                        System.out.println("test case: " + count);

                        byte[] seed = Hex.decode((String)buf.get("seed")); // seed for Dilithium secure random
                        byte[] pk = Hex.decode((String)buf.get("pk"));     // public key
                        byte[] sk = Hex.decode((String)buf.get("sk"));     // private key
                        byte[] sm = Hex.decode((String)buf.get("sm"));     // signed message
                        int sm_len = Integer.parseInt((String)buf.get("smlen"));
                        byte[] msg = Hex.decode((String)buf.get("msg")); // message
                        int m_len = Integer.parseInt((String)buf.get("mlen"));

                        NISTSecureRandom random = new NISTSecureRandom(seed, null);

                        // keygen
                        DilithiumKeyGenerationParameters kparam = new DilithiumKeyGenerationParameters(random, parameters[fileindex]);
                        DilithiumKeyPairGenerator kpg = new DilithiumKeyPairGenerator();
                        kpg.init(kparam);

                        AsymmetricCipherKeyPair kp = kpg.generateKeyPair();

                        DilithiumPublicKeyParameters pubParams = (DilithiumPublicKeyParameters)PublicKeyFactory.createKey(
                            SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((DilithiumPublicKeyParameters)kp.getPublic()));
                        DilithiumPrivateKeyParameters privParams = (DilithiumPrivateKeyParameters)PrivateKeyFactory.createKey(
                            PrivateKeyInfoFactory.createPrivateKeyInfo((DilithiumPrivateKeyParameters)kp.getPrivate()));

                        assertTrue(name + " " + count + " public key", Arrays.areEqual(pk, pubParams.getEncoded()));
                        assertTrue(name + " " + count + " secret key", Arrays.areEqual(sk, privParams.getEncoded()));

                        // sign
                        DilithiumSigner signer = new DilithiumSigner();
                        DilithiumPrivateKeyParameters skparam = (DilithiumPrivateKeyParameters)kp.getPrivate();

                        signer.init(true, skparam);

                        byte[] sigGenerated = signer.generateSignature(msg);
                        byte[] attachedSig = Arrays.concatenate(sigGenerated, msg);

                        // verify
                        DilithiumSigner verifier = new DilithiumSigner();
                        DilithiumPublicKeyParameters pkparam = pubParams;
                        verifier.init(false, pkparam);

                        boolean vrfyrespass = verifier.verifySignature(msg, sigGenerated);
                        sigGenerated[3]++; // changing the signature by 1 byte should cause it to fail
                        boolean vrfyresfail = verifier.verifySignature(msg, sigGenerated);

                        // print results
                            /*
                            System.out.println("--Keygen");
                            boolean kgenpass = true;
                            if (!Arrays.areEqual(respk, pk)) {
                                System.out.println("  == Keygen: pk do not match");
                                kgenpass = false;
                            }
                            if (!Arrays.areEqual(ressk, sk)) {
                                System.out.println("  == Keygen: sk do not match");
                                kgenpass = false;
                            }
                            if (kgenpass) {
                                System.out.println("  ++ Keygen pass");
                            } else {
                                System.out.println("  == Keygen failed");
                                return;
                            }

                            System.out.println("--Sign");
                            boolean spass = true;
                            if (!Arrays.areEqual(ressm, sm)) {
                                System.out.println("  == Sign: signature do not match");
                                spass = false;
                            }
                            if (spass) {
                                System.out.println("  ++ Sign pass");
                            } else {
                                System.out.println("  == Sign failed");
                                return;
                            }

                            System.out.println("--Verify");
                            if (vrfyrespass && !vrfyresfail) {
                                System.out.println("  ++ Verify pass");
                            } else {
                                System.out.println("  == Verify failed");
                                return;
                            }
                             */
                        // AssertTrue

                        //sign
                        // System.out.println("attached Sig = ");
                        // Helper.printByteArray(attachedSig);
                        // System.out.println("sm = ");
                        // Helper.printByteArray(sm);
                     
                        assertTrue(name + " " + count + " signature", Arrays.areEqual(attachedSig, sm));

                        //verify
                        assertTrue(name + " " + count + " verify failed when should pass", vrfyrespass);
                        assertFalse(name + " " + count + " verify passed when should fail", vrfyresfail);

                    }
                    buf.clear();

                    continue;
                }

                int a = line.indexOf("=");
                if (a > -1)
                {
                    buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
                }


            }
            System.out.println("testing successful!");
        }
    }

    public void testDilithiumRandom()
    {
        byte[] msg = Strings.toByteArray("Hello World!");
        DilithiumKeyPairGenerator keyGen = new DilithiumKeyPairGenerator();

        SecureRandom random = new SecureRandom();

        keyGen.init(new DilithiumKeyGenerationParameters(random, DilithiumParameters.dilithium3));

        for (int i = 0; i != 1000; i++)
        {
            AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();

            // sign
            DilithiumSigner signer = new DilithiumSigner();
            DilithiumPrivateKeyParameters skparam = (DilithiumPrivateKeyParameters)keyPair.getPrivate();
            ParametersWithRandom skwrand = new ParametersWithRandom(skparam, random);
            signer.init(true, skwrand);

            byte[] sigGenerated = signer.generateSignature(msg);

            // verify
            DilithiumSigner verifier = new DilithiumSigner();
            DilithiumPublicKeyParameters pkparam = (DilithiumPublicKeyParameters)keyPair.getPublic();
            verifier.init(false, pkparam);

            assertTrue("count = " + i, verifier.verifySignature(msg, sigGenerated));
        }
    }
}
