/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;
import javax.security.sasl.SaslClient;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SASLClientBindHandler {
    @Nullable
    private final Control[] controls;
    private volatile int messageID;
    @NotNull
    private final LDAPConnection connection;
    @NotNull
    private final List<String> unhandledCallbackMessages;
    private final long responseTimeoutMillis;
    @NotNull
    private final SASLBindRequest bindRequest;
    @NotNull
    private final SaslClient saslClient;
    @NotNull
    private final String mechanism;

    public SASLClientBindHandler(@NotNull SASLBindRequest bindRequest, @NotNull LDAPConnection connection, @NotNull String mechanism, @NotNull SaslClient saslClient, @Nullable Control[] controls, long responseTimeoutMillis, @NotNull List<String> unhandledCallbackMessages) {
        this.bindRequest = bindRequest;
        this.connection = connection;
        this.mechanism = mechanism;
        this.saslClient = saslClient;
        this.controls = controls;
        this.responseTimeoutMillis = responseTimeoutMillis;
        this.unhandledCallbackMessages = unhandledCallbackMessages;
        this.messageID = -1;
    }

    @NotNull
    public BindResult processSASLBind() throws LDAPException {
        try {
            byte[] credBytes = null;
            try {
                if (this.saslClient.hasInitialResponse()) {
                    credBytes = this.saslClient.evaluateChallenge(new byte[0]);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (this.unhandledCallbackMessages.isEmpty()) {
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_INITIAL_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
                }
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_INITIAL_REQUEST_UNHANDLED_CALLBACKS.get(this.mechanism, StaticUtils.getExceptionMessage(e), StaticUtils.concatenateStrings(this.unhandledCallbackMessages)), e);
            }
            ASN1OctetString saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
            BindResult bindResult = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
            this.messageID = this.bindRequest.getLastMessageID();
            if (!bindResult.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) {
                BindResult bindResult2 = bindResult;
                return bindResult2;
            }
            ASN1OctetString serverCreds = bindResult.getServerSASLCredentials();
            byte[] serverCredBytes = serverCreds == null ? null : serverCreds.getValue();
            while (true) {
                try {
                    credBytes = this.saslClient.evaluateChallenge(serverCredBytes);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (this.unhandledCallbackMessages.isEmpty()) {
                        throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_SUBSEQUENT_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
                    }
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_SUBSEQUENT_REQUEST_UNHANDLED_CALLBACKS.get(this.mechanism, StaticUtils.getExceptionMessage(e), StaticUtils.concatenateStrings(this.unhandledCallbackMessages)), e);
                }
                saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
                bindResult = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
                this.messageID = this.bindRequest.getLastMessageID();
                if (!bindResult.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) {
                    ASN1OctetString serverCredentials = bindResult.getServerSASLCredentials();
                    if (serverCredentials != null) {
                        try {
                            this.saslClient.evaluateChallenge(serverCredentials.getValue());
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    BindResult bindResult3 = bindResult;
                    return bindResult3;
                }
                serverCreds = bindResult.getServerSASLCredentials();
                if (serverCreds == null) {
                    serverCredBytes = null;
                    continue;
                }
                serverCredBytes = serverCreds.getValue();
            }
        }
        finally {
            String qopString;
            Object qopObject;
            boolean hasNegotiatedSecurity = false;
            if (this.saslClient.isComplete() && (qopObject = this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) != null && ((qopString = StaticUtils.toLowerCase(String.valueOf(qopObject))).contains(SASLQualityOfProtection.AUTH_INT.toString()) || qopString.contains(SASLQualityOfProtection.AUTH_CONF.toString()))) {
                hasNegotiatedSecurity = true;
            }
            if (hasNegotiatedSecurity) {
                this.connection.applySASLSecurityLayer(this.saslClient);
            } else {
                try {
                    this.saslClient.dispose();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    public int getMessageID() {
        return this.messageID;
    }
}

