/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TopologyRegistryTrustManagerProperties
implements Serializable {
    private static final long DEFAULT_CACHE_DURATION_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final long serialVersionUID = -4753111539481801666L;
    private boolean ignoreIssuerCertificateValidityWindow;
    private boolean ignorePeerCertificateValidityWindow;
    private boolean requirePeerCertificateInTopologyRegistry;
    @NotNull
    private File configurationFile;
    private long cacheDurationMillis;

    public TopologyRegistryTrustManagerProperties(@NotNull String configurationFilePath) {
        this(new File(configurationFilePath));
    }

    public TopologyRegistryTrustManagerProperties(@NotNull File configurationFile) {
        Validator.ensureNotNull(configurationFile, "TopologyRegistryTrustManagerProperties.configurationFile must not be null.");
        this.configurationFile = configurationFile;
        this.cacheDurationMillis = DEFAULT_CACHE_DURATION_MILLIS;
        this.requirePeerCertificateInTopologyRegistry = false;
        this.ignorePeerCertificateValidityWindow = false;
        this.ignoreIssuerCertificateValidityWindow = false;
    }

    @NotNull
    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(@NotNull File configurationFile) {
        Validator.ensureNotNull(configurationFile, "TopologyRegistryTrustManagerProperties.configurationFile must not be null.");
        this.configurationFile = configurationFile;
    }

    public long getCacheDurationMillis() {
        return this.cacheDurationMillis;
    }

    public void setCacheDuration(long cacheDurationValue, @NotNull TimeUnit cacheDurationTimeUnit) {
        Validator.ensureNotNullWithMessage((Object)cacheDurationTimeUnit, "TopologyRegistryTrustManagerProperties.setCacheDuration.cacheDurationTimeUnit must not be null.");
        this.cacheDurationMillis = cacheDurationValue <= 0L ? 0L : cacheDurationTimeUnit.toMillis(cacheDurationValue);
    }

    public boolean requirePeerCertificateInTopologyRegistry() {
        return this.requirePeerCertificateInTopologyRegistry;
    }

    public void setRequirePeerCertificateInTopologyRegistry(boolean requirePeerCertificateInTopologyRegistry) {
        this.requirePeerCertificateInTopologyRegistry = requirePeerCertificateInTopologyRegistry;
    }

    public boolean ignorePeerCertificateValidityWindow() {
        return this.ignorePeerCertificateValidityWindow;
    }

    public void setIgnorePeerCertificateValidityWindow(boolean ignorePeerCertificateValidityWindow) {
        this.ignorePeerCertificateValidityWindow = ignorePeerCertificateValidityWindow;
    }

    public boolean ignoreIssuerCertificateValidityWindow() {
        return this.ignoreIssuerCertificateValidityWindow;
    }

    public void setIgnoreIssuerCertificateValidityWindow(boolean ignoreIssuerCertificateValidityWindow) {
        this.ignoreIssuerCertificateValidityWindow = ignoreIssuerCertificateValidityWindow;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TopologyRegistryTrustManagerProperties(configurationFile='");
        buffer.append(this.configurationFile.getAbsolutePath());
        buffer.append("', cacheDurationMillis=");
        buffer.append(this.cacheDurationMillis);
        buffer.append(", requirePeerCertificateInTopologyRegistry=");
        buffer.append(this.requirePeerCertificateInTopologyRegistry);
        buffer.append(", ignorePeerCertificateValidityWindow=");
        buffer.append(this.ignorePeerCertificateValidityWindow);
        buffer.append(", ignoreIssuerCertificateValidityWindow=");
        buffer.append(this.ignoreIssuerCertificateValidityWindow);
        buffer.append(')');
    }
}

