/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.AbstractBranchDuplicationCheck;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1871")
public class DuplicateBranchCheck
extends AbstractBranchDuplicationCheck {
    @Override
    protected void checkDuplicatedBranches(CheckContext ctx, Tree tree, List<Tree> branches) {
        for (List<Tree> group : SyntacticEquivalence.findDuplicatedGroups(branches)) {
            Tree original = group.get(0);
            group.stream().skip(1L).filter(DuplicateBranchCheck::spansMultipleLines).forEach(duplicated -> {
                TextRange originalRange = original.metaData().textRange();
                ctx.reportIssue((HasTextRange)duplicated, "This branch's code block is the same as the block for the branch on line " + originalRange.start().line() + ".", new SecondaryLocation(originalRange, "Original"));
            });
        }
    }

    @Override
    protected void onAllIdenticalBranches(CheckContext ctx, Tree tree) {
    }

    protected static boolean spansMultipleLines(@Nullable Tree tree) {
        if (tree == null) {
            return false;
        }
        if (tree instanceof BlockTree) {
            BlockTree block = (BlockTree)tree;
            List<Tree> statements = block.statementOrExpressions();
            if (statements.isEmpty()) {
                return false;
            }
            Tree firstStatement = statements.get(0);
            Tree lastStatement = statements.get(statements.size() - 1);
            return firstStatement.metaData().textRange().start().line() != lastStatement.metaData().textRange().end().line();
        }
        TextRange range = tree.metaData().textRange();
        return range.start().line() < range.end().line();
    }
}

