/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class SarifVersionValidator {
    public static final Set<String> SUPPORTED_SARIF_VERSIONS = Set.of("2.1.0");
    public static final String UNSUPPORTED_VERSION_MESSAGE_TEMPLATE = "Version [%s] of SARIF is not supported";

    private SarifVersionValidator() {
    }

    public static void validateSarifVersion(@Nullable String version) {
        if (!SarifVersionValidator.isSupportedSarifVersion(version)) {
            throw new IllegalStateException(SarifVersionValidator.composeUnsupportedVersionMessage(version));
        }
    }

    private static boolean isSupportedSarifVersion(@Nullable String version) {
        return Optional.ofNullable(version).filter(SUPPORTED_SARIF_VERSIONS::contains).isPresent();
    }

    private static String composeUnsupportedVersionMessage(@Nullable String version) {
        return String.format(UNSUPPORTED_VERSION_MESSAGE_TEMPLATE, version);
    }
}

