/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.utils.Preconditions;
import org.sonar.scanner.cache.ScannerWriteCache;
import org.sonar.scanner.scan.branch.BranchConfiguration;

public class WriteCacheImpl
implements ScannerWriteCache {
    private final ReadCache readCache;
    private final BranchConfiguration branchConfiguration;
    private final Map<String, byte[]> cache = new HashMap<String, byte[]>();

    public WriteCacheImpl(ReadCache readCache, BranchConfiguration branchConfiguration) {
        this.readCache = readCache;
        this.branchConfiguration = branchConfiguration;
    }

    @Override
    public void write(String key, InputStream data) {
        Preconditions.checkNotNull(data);
        this.checkKey(key);
        if (this.branchConfiguration.isPullRequest()) {
            return;
        }
        try {
            byte[] arr = data.readAllBytes();
            this.cache.put(key, arr);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read stream", e);
        }
    }

    @Override
    public void write(String key, byte[] data) {
        Preconditions.checkNotNull(data);
        this.checkKey(key);
        if (this.branchConfiguration.isPullRequest()) {
            return;
        }
        this.cache.put(key, Arrays.copyOf(data, data.length));
    }

    @Override
    public void copyFromPrevious(String key) {
        Preconditions.checkArgument(this.readCache.contains(key), "Previous cache doesn't contain key '%s'", key);
        this.checkKey(key);
        if (this.branchConfiguration.isPullRequest()) {
            return;
        }
        try {
            this.cache.put(key, this.readCache.read(key).readAllBytes());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read plugin cache for key " + key, e);
        }
    }

    @Override
    public Map<String, byte[]> getCache() {
        return Collections.unmodifiableMap(this.cache);
    }

    private void checkKey(String key) {
        Preconditions.checkNotNull(key);
        Preconditions.checkArgument(!this.cache.containsKey(key), "Cache already contains key '%s'", key);
    }
}

