/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.core.sarif.Region;

@ScannerSide
public class RegionMapper {
    Optional<TextRange> mapRegion(@Nullable Region region, InputFile file) {
        if (region == null) {
            return Optional.empty();
        }
        int startLine = Objects.requireNonNull(region.getStartLine(), "No start line defined for the region.");
        Integer endLine = region.getEndLine();
        if (endLine != null) {
            int startColumn = Optional.ofNullable(region.getStartColumn()).map(RegionMapper::adjustSarifColumnIndexToSqIndex).orElse(0);
            int endColumn = Optional.ofNullable(region.getEndColumn()).map(RegionMapper::adjustSarifColumnIndexToSqIndex).orElseGet(() -> file.selectLine(endLine).end().lineOffset());
            return Optional.of(file.newRange(startLine, startColumn, endLine, endColumn));
        }
        return Optional.of(file.selectLine(startLine));
    }

    private static int adjustSarifColumnIndexToSqIndex(int index) {
        return index - 1;
    }
}

