/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;
import org.sonar.scanner.rule.RulesLoader;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.GetRequest;

public class DefaultRulesLoader
implements RulesLoader {
    private static final String RULES_SEARCH_URL = "/api/rules/list.protobuf";
    private final DefaultScannerWsClient wsClient;

    public DefaultRulesLoader(DefaultScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public List<Rules.ListResponse.Rule> load() {
        GetRequest getRequest = new GetRequest(RULES_SEARCH_URL);
        Rules.ListResponse list = DefaultRulesLoader.loadFromStream(this.wsClient.call(getRequest).contentStream());
        return list.getRulesList();
    }

    private static Rules.ListResponse loadFromStream(InputStream is) {
        try {
            Rules.ListResponse listResponse = Rules.ListResponse.parseFrom(is);
            return listResponse;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get rules", e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

