/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.maven;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.checks.maven.helpers.MavenDependencyMatcher;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Rule(key="S3417")
@DeprecatedRuleKey(repositoryKey="java", ruleKey="S3417")
public class DisallowedDependenciesCheck
extends SimpleXPathBasedCheck {
    public static final String KEY = "S3417";
    private final XPathExpression dependencyExpression = this.getXPathExpression("//dependencies/dependency");
    private final XPathExpression propertiesExpression = this.getXPathExpression("//properties");
    private final Pattern propertyPlaceholderPattern = Pattern.compile("\\$\\{(?<property>[^}]++)}");
    @RuleProperty(key="dependencyName", description="Pattern describing forbidden dependencies group and artifact ids. E.G. '``*:.*log4j``' or '``x.y:*``'")
    public String dependencyName = "";
    @RuleProperty(key="version", description="Dependency version pattern or dash-delimited range. Leave blank for all versions. E.G. '``1.3.*``', '``1.0-3.1``', '``1.0-*``' or '``*-3.1``'")
    public String version = "";
    private MavenDependencyMatcher matcher = null;

    @Override
    public void scanFile(XmlFile xmlFile) {
        if (!"pom.xml".equalsIgnoreCase(xmlFile.getInputFile().filename())) {
            return;
        }
        HashMap propertiesMap = new HashMap();
        this.evaluateAsList(this.propertiesExpression, xmlFile.getNamespaceUnawareDocument()).forEach(properties -> XmlFile.children(properties).stream().filter(node -> node.getNodeType() == 1).forEach(property -> propertiesMap.put(property.getNodeName(), property.getTextContent())));
        this.evaluateAsList(this.dependencyExpression, xmlFile.getNamespaceUnawareDocument()).forEach(dependency -> {
            String groupId = DisallowedDependenciesCheck.getChildElementText("groupId", dependency);
            String artifactId = DisallowedDependenciesCheck.getChildElementText("artifactId", dependency);
            String dependencyVersion = this.resolveDependencyVersion(propertiesMap, (Node)dependency);
            if (this.getMatcher().matches(groupId, artifactId, dependencyVersion)) {
                this.reportIssue((Node)dependency, "Remove this forbidden dependency.");
            }
        });
    }

    private String resolveDependencyVersion(Map<String, String> propertiesMap, Node dependency) {
        String dependencyVersion = DisallowedDependenciesCheck.getChildElementText("version", dependency);
        Matcher placeholderMatcher = this.propertyPlaceholderPattern.matcher(dependencyVersion);
        if (placeholderMatcher.matches()) {
            dependencyVersion = propertiesMap.getOrDefault(placeholderMatcher.group("property"), "");
        }
        return dependencyVersion;
    }

    private static String getChildElementText(String childElementName, Node parent) {
        for (Node node : XmlFile.children(parent)) {
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(childElementName)) continue;
            return node.getTextContent();
        }
        return "";
    }

    private MavenDependencyMatcher getMatcher() {
        if (this.matcher == null) {
            try {
                this.matcher = new MavenDependencyMatcher(this.dependencyName, this.version);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[S3417] Unable to build matchers from provided dependency name: " + this.dependencyName, e);
            }
        }
        return this.matcher;
    }
}

