/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.text.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.text.api.CheckContext;
import org.sonar.plugins.text.api.TextCheck;
import org.sonar.plugins.text.core.InputFileContext;

public class ChecksVisitor {
    private final Set<ContextAdapter> contextAdapters = new HashSet<ContextAdapter>();
    private final Collection<TextCheck> activeChecks;

    public ChecksVisitor(Checks<TextCheck> checks) {
        this.activeChecks = checks.all();
        for (TextCheck check : this.activeChecks) {
            RuleKey ruleKey = checks.ruleKey((Object)check);
            Objects.requireNonNull(ruleKey);
            ContextAdapter contextAdapter = new ContextAdapter(ruleKey);
            this.contextAdapters.add(contextAdapter);
            check.initialize(contextAdapter);
        }
    }

    public void scan(InputFileContext inputFileContext) {
        this.contextAdapters.forEach(ctx -> {
            ctx.currentCtx = inputFileContext;
        });
        this.activeChecks.forEach(check -> check.analyze(inputFileContext.inputFile));
    }

    public static class ContextAdapter
    implements CheckContext {
        public final RuleKey ruleKey;
        private InputFileContext currentCtx;

        public ContextAdapter(RuleKey ruleKey) {
            this.ruleKey = ruleKey;
        }

        @Override
        public void reportLineIssue(int line, String message) {
            this.currentCtx.reportLineIssue(this.ruleKey, line, message);
        }
    }
}

