/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonScanner;
import org.sonar.plugins.python.api.ProjectPythonVersion;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.plugins.python.indexer.SonarQubePythonIndexer;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.checks.CheckList;
import org.sonarsource.performance.measure.PerformanceMeasure;

public final class PythonSensor
implements Sensor {
    private static final String PERFORMANCE_MEASURE_PROPERTY = "sonar.python.performance.measure";
    private static final String PERFORMANCE_MEASURE_FILE_PATH_PROPERTY = "sonar.python.performance.measure.path";
    private static final String PERFORMANCE_MEASURE_DESTINATION_FILE = "sonar-python-performance-measure.json";
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonIndexer indexer;
    private final AnalysisWarningsWrapper analysisWarnings;
    private static final Logger LOG = Loggers.get(PythonSensor.class);
    static final String UNSET_VERSION_WARNING = "Your code is analyzed as compatible with python 2 and 3 by default. This will prevent the detection of issues specific to python 2 or python 3. You can get a more precise analysis by setting a python version in your configuration via the parameter \"sonar.python.version\"";

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, AnalysisWarningsWrapper analysisWarnings) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null, null, analysisWarnings);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, PythonCustomRuleRepository[] customRuleRepositories, AnalysisWarningsWrapper analysisWarnings) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, customRuleRepositories, null, analysisWarnings);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, PythonIndexer indexer, AnalysisWarningsWrapper analysisWarnings) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null, indexer, analysisWarnings);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PythonCustomRuleRepository[] customRuleRepositories, @Nullable PythonIndexer indexer, AnalysisWarningsWrapper analysisWarnings) {
        this.checks = new PythonChecks(checkFactory).addChecks("python", CheckList.getChecks()).addCustomChecks(customRuleRepositories);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.indexer = indexer;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("py").name("Python Sensor");
    }

    public void execute(SensorContext context) {
        PerformanceMeasure.Duration durationReport = PythonSensor.createPerformanceMeasureReport(context);
        List<InputFile> pythonFiles = PythonSensor.getInputFiles(context);
        Optional pythonVersionParameter = context.config().get("sonar.python.version");
        if (!pythonVersionParameter.isPresent() && context.runtime().getProduct() != SonarProduct.SONARLINT) {
            LOG.warn(UNSET_VERSION_WARNING);
            this.analysisWarnings.addUnique(UNSET_VERSION_WARNING);
        }
        pythonVersionParameter.ifPresent(value -> ProjectPythonVersion.setCurrentVersions(PythonVersionUtils.fromString(value)));
        CacheContextImpl cacheContext = CacheContextImpl.of(context);
        PythonIndexer pythonIndexer = this.indexer != null ? this.indexer : new SonarQubePythonIndexer(pythonFiles, cacheContext);
        PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, pythonIndexer);
        scanner.execute(pythonFiles, context);
        durationReport.stop();
    }

    private static List<InputFile> getInputFiles(SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        Iterable it = context.fileSystem().inputFiles(p.and(new FilePredicate[]{p.hasLanguage("py")}));
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        return Collections.unmodifiableList(list);
    }

    private static PerformanceMeasure.Duration createPerformanceMeasureReport(SensorContext context) {
        return PerformanceMeasure.reportBuilder().activate(context.config().getBoolean(PERFORMANCE_MEASURE_PROPERTY).orElse(Boolean.FALSE)).toFile(context.config().get(PERFORMANCE_MEASURE_FILE_PATH_PROPERTY).filter(path -> !path.isEmpty()).orElseGet(() -> Optional.ofNullable(context.fileSystem().workDir()).filter(File::exists).map(file -> file.toPath().resolve(PERFORMANCE_MEASURE_DESTINATION_FILE).toString()).orElse(null))).appendMeasurementCost().start("PythonSensor");
    }
}

