/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.caching;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.DescriptorsToProtobuf;
import org.sonar.python.types.protobuf.DescriptorsProtos;

public class Caching {
    private final CacheContext cacheContext;
    public static final String IMPORTS_MAP_CACHE_KEY_PREFIX = "python:imports:";
    public static final String PROJECT_SYMBOL_TABLE_CACHE_KEY_PREFIX = "python:descriptors:";
    public static final String PROJECT_FILES_KEY = "python:files";
    private static final Logger LOG = Loggers.get(Caching.class);

    public Caching(CacheContext cacheContext) {
        this.cacheContext = cacheContext;
    }

    public void writeImportsMapEntry(String moduleFqn, Set<String> imports) {
        byte[] importData = String.join((CharSequence)";", imports).getBytes(StandardCharsets.UTF_8);
        String cacheKey = IMPORTS_MAP_CACHE_KEY_PREFIX + moduleFqn;
        this.cacheContext.getWriteCache().write(cacheKey, importData);
    }

    public void writeFilesList(List<String> mainFiles) {
        byte[] projectFiles = String.join((CharSequence)";", mainFiles).getBytes(StandardCharsets.UTF_8);
        this.cacheContext.getWriteCache().write(PROJECT_FILES_KEY, projectFiles);
    }

    public void writeProjectLevelSymbolTableEntry(String moduleFqn, Set<Descriptor> descriptors) {
        String cacheKey = PROJECT_SYMBOL_TABLE_CACHE_KEY_PREFIX + moduleFqn;
        this.cacheContext.getWriteCache().write(cacheKey, DescriptorsToProtobuf.toProtobufModuleDescriptor(descriptors).toByteArray());
    }

    public void copyFromPrevious(String moduleFqn) {
        this.cacheContext.getWriteCache().copyFromPrevious(IMPORTS_MAP_CACHE_KEY_PREFIX + moduleFqn);
        this.cacheContext.getWriteCache().copyFromPrevious(PROJECT_SYMBOL_TABLE_CACHE_KEY_PREFIX + moduleFqn);
    }

    @CheckForNull
    public Set<Descriptor> readProjectLevelSymbolTableEntry(String module) {
        byte[] bytes;
        String key = PROJECT_SYMBOL_TABLE_CACHE_KEY_PREFIX + module;
        if (this.cacheContext.getReadCache().contains(key) && (bytes = this.cacheContext.getReadCache().readBytes(key)) != null) {
            try {
                return DescriptorsToProtobuf.fromProtobuf(DescriptorsProtos.ModuleDescriptor.parseFrom(bytes));
            }
            catch (InvalidProtocolBufferException e) {
                LOG.debug("Failed to deserialize project level symbol table entry for module: \"{}\"", (Object)module);
            }
        }
        return null;
    }

    @CheckForNull
    public Set<String> readImportMapEntry(String moduleFqn) {
        String cacheKey = IMPORTS_MAP_CACHE_KEY_PREFIX + moduleFqn;
        byte[] bytes = this.cacheContext.getReadCache().readBytes(cacheKey);
        if (bytes != null) {
            return new HashSet<String>(Arrays.asList(new String(bytes, StandardCharsets.UTF_8).split(";")));
        }
        return null;
    }

    public Set<String> readFilesList() {
        byte[] bytes = this.cacheContext.getReadCache().readBytes(PROJECT_FILES_KEY);
        if (bytes != null) {
            return new HashSet<String>(Arrays.asList(new String(bytes, StandardCharsets.UTF_8).split(";")));
        }
        return Collections.emptySet();
    }

    public boolean isCacheEnabled() {
        return this.cacheContext.isCacheEnabled();
    }

    public CacheContext cacheContext() {
        return this.cacheContext;
    }
}

