/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraph {
    private final Map<String, Set<String>> dependentModules;

    private DependencyGraph(Map<String, Set<String>> dependentModules) {
        this.dependentModules = dependentModules;
    }

    public Map<String, Set<String>> dependentModules() {
        return Collections.unmodifiableMap(this.dependentModules);
    }

    public static DependencyGraph from(Map<String, Set<String>> importsByModule, Set<String> projectModulesFQN) {
        Map<String, Set<String>> dependentModules = DependencyGraph.computeDependentModules(importsByModule, projectModulesFQN);
        return new DependencyGraph(dependentModules);
    }

    private static Map<String, Set<String>> computeDependentModules(Map<String, Set<String>> importsByModule, Set<String> projectModulesFQN) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : importsByModule.entrySet()) {
            entry.getValue().forEach(importedModuleFQN -> {
                String dependentModule = (String)entry.getKey();
                if (projectModulesFQN.contains(importedModuleFQN)) {
                    result.computeIfAbsent((String)importedModuleFQN, x -> new HashSet()).add(dependentModule);
                    return;
                }
                int endIndex = importedModuleFQN.lastIndexOf(".");
                if (endIndex < 0) {
                    return;
                }
                String substring = importedModuleFQN.substring(0, endIndex);
                if (projectModulesFQN.contains(substring)) {
                    result.computeIfAbsent(substring, x -> new HashSet()).add(dependentModule);
                }
            });
        }
        return result;
    }

    public Set<String> impactedModules(List<String> modifiedModules) {
        HashSet<String> impactedModules = new HashSet<String>();
        for (String modifiedModuleFQN : modifiedModules) {
            this.recursivelyComputeImpactedModules(modifiedModuleFQN, impactedModules);
        }
        return impactedModules;
    }

    private void recursivelyComputeImpactedModules(String changedModule, Set<String> impactedModules) {
        if (!impactedModules.contains(changedModule)) {
            impactedModules.add(changedModule);
            Set<String> transitivelyImpactedModules = this.dependentModules.get(changedModule);
            if (transitivelyImpactedModules == null) {
                return;
            }
            for (String transitivelyImpacted : transitivelyImpactedModules) {
                this.recursivelyComputeImpactedModules(transitivelyImpacted, impactedModules);
            }
        }
    }
}

