/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

public class UnittestUtils {
    public static final Set<String> RUN_METHODS = Set.of("setUp", "tearDown", "setUpClass", "tearDownClass", "run", "skiptTest", "subTest", "debug");
    public static final Set<String> RAISE_METHODS = Set.of("assertRaises", "assertRaisesRegexp", "assertRaisesRegex");
    public static final Set<String> ASSERTIONS_METHODS = Set.of("assertEqual", "assertNotEqual", "assertTrue", "assertFalse", "assertIs", "assertIsNot", "assertIsNone", "assertIsNotNone", "assertIn", "assertNotIn", "assertIsInstance", "assertNotIsInstance", "assertAlmostEqual", "assertNotAlmostEqual", "assertGreater", "assertGreaterEqual", "assertLess", "assertLessEqual", "assertRegexpMatches", "assertNotRegexpMatches", "assertItemsEqual", "assertDictContainsSubset", "assertMultiLineEqual", "assertSequenceEqual", "assertListEqual", "assertTupleEqual", "assertSetEqual", "assertDictEqual", "assertWarns", "assertWarnsRegex", "assertLogs", "assertNoLogs", "assertRegex", "assertNotRegex", "assertCountEqual");
    public static final Set<String> UTIL_METHODS = Set.of("addTypeEqualityFunc", "fail", "failureException", "longMessage", "maxDiff");
    public static final Set<String> GATHER_INFO_METHODS = Set.of("countTestCases", "defaultTestResult", "id", "shortDescription", "addCleanup", "doCleanups", "addClassCleanup", "doClassCleanups");
    private static final Set<String> ALL_METHODS = new HashSet<String>();
    private static final Set<String> ALL_ASSERT_METHODS = new HashSet<String>();

    private UnittestUtils() {
    }

    public static Set<String> allMethods() {
        return Collections.unmodifiableSet(ALL_METHODS);
    }

    public static Set<String> allAssertMethods() {
        return Collections.unmodifiableSet(ALL_ASSERT_METHODS);
    }

    public static boolean isWithinUnittestTestCase(Tree tree) {
        ArrayList<String> parentClassesFQN = new ArrayList<String>();
        ClassDef classDef = (ClassDef)TreeUtils.firstAncestorOfKind(tree, Tree.Kind.CLASSDEF);
        if (classDef != null) {
            parentClassesFQN.addAll(TreeUtils.getParentClassesFQN(classDef));
        }
        return parentClassesFQN.stream().anyMatch(parentClass -> parentClass.contains("unittest") && parentClass.contains("TestCase"));
    }

    static {
        ALL_METHODS.addAll(RUN_METHODS);
        ALL_METHODS.addAll(UTIL_METHODS);
        ALL_METHODS.addAll(GATHER_INFO_METHODS);
        ALL_METHODS.addAll(ASSERTIONS_METHODS);
        ALL_METHODS.addAll(RAISE_METHODS);
        ALL_ASSERT_METHODS.addAll(ASSERTIONS_METHODS);
        ALL_ASSERT_METHODS.addAll(RAISE_METHODS);
    }
}

