/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Pattern;
import org.sonar.plugins.python.api.tree.SequencePattern;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class SequencePatternImpl
extends PyTree
implements SequencePattern {
    @Nullable
    private final Token leftDelimiter;
    private final List<Pattern> elements;
    private final List<Token> commas;
    @Nullable
    private final Token rightDelimiter;

    public SequencePatternImpl(@Nullable Token leftDelimiter, List<Pattern> elements, List<Token> commas, @Nullable Token rightDelimiter) {
        this.leftDelimiter = leftDelimiter;
        this.elements = elements;
        this.commas = commas;
        this.rightDelimiter = rightDelimiter;
    }

    @Override
    @CheckForNull
    public Token lDelimiter() {
        return this.leftDelimiter;
    }

    @Override
    public List<Pattern> elements() {
        return this.elements;
    }

    @Override
    public List<Token> commas() {
        return this.commas;
    }

    @Override
    @CheckForNull
    public Token rDelimiter() {
        return this.rightDelimiter;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSequencePattern(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SEQUENCE_PATTERN;
    }

    @Override
    List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (this.leftDelimiter != null) {
            children.add(this.leftDelimiter);
        }
        int i = 0;
        for (Pattern element : this.elements) {
            children.add(element);
            if (i < this.commas.size()) {
                children.add(this.commas.get(i));
            }
            ++i;
        }
        if (this.rightDelimiter != null) {
            children.add(this.rightDelimiter);
        }
        return children;
    }
}

