/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1656")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/SelfAssignmentCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class SelfAssignmentCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EQ)) {
            KtExpression ktExpression = expression2.getLeft();
            Intrinsics.checkNotNull(ktExpression);
            PsiElement psiElement = ktExpression;
            KtExpression ktExpression2 = expression2.getRight();
            Intrinsics.checkNotNull(ktExpression2);
            if (SyntacticEquivalence.INSTANCE.areEquivalent(psiElement, ktExpression2)) {
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, expression2, "Remove or correct this useless self-assignment.", null, null, 12, null);
            }
        }
    }
}

