/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayList;
import java.util.List;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.BackReferenceTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassIntersectionTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexToken;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class ComplexRegexFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Simplify this regular expression to reduce its complexity from %d to the %d allowed.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private final int max;
    private int complexity = 0;
    private int nesting = 1;
    private final List<RegexIssueLocation> components = new ArrayList<RegexIssueLocation>();

    public ComplexRegexFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter, int max) {
        this.regexElementIssueReporter = regexElementIssueReporter;
        this.max = max;
    }

    private void increaseComplexity(RegexSyntaxElement syntaxElement, int increment) {
        this.complexity += increment;
        String message = "+" + increment;
        if (increment > 1) {
            message = message + " (incl " + (increment - 1) + " for nesting)";
        }
        this.components.add(new RegexIssueLocation(syntaxElement, message));
    }

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        this.increaseComplexity(tree.getOrOperators().get(0), this.nesting);
        for (SourceCharacter orOperator : tree.getOrOperators().subList(1, tree.getOrOperators().size())) {
            this.increaseComplexity(orOperator, 1);
        }
        ++this.nesting;
        super.visitDisjunction(tree);
        --this.nesting;
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        this.increaseComplexity(tree.getQuantifier(), this.nesting);
        ++this.nesting;
        super.visitRepetition(tree);
        --this.nesting;
    }

    @Override
    public void visitCharacterClass(CharacterClassTree tree) {
        this.increaseComplexity(tree.getOpeningBracket(), 1);
        ++this.nesting;
        super.visitCharacterClass(tree);
        --this.nesting;
    }

    @Override
    public void visitCharacterClassIntersection(CharacterClassIntersectionTree tree) {
        this.increaseComplexity(tree.getAndOperators().get(0), this.nesting - 1);
        for (RegexToken andOperator : tree.getAndOperators().subList(1, tree.getAndOperators().size())) {
            this.increaseComplexity(andOperator, 1);
        }
        ++this.nesting;
        super.visitCharacterClassIntersection(tree);
        --this.nesting;
    }

    @Override
    public void visitNonCapturingGroup(NonCapturingGroupTree tree) {
        if (tree.getEnabledFlags().isEmpty() && tree.getDisabledFlags().isEmpty()) {
            super.visitNonCapturingGroup(tree);
        } else {
            if (tree.getGroupHeader() == null) {
                this.increaseComplexity(tree, this.nesting);
            } else {
                this.increaseComplexity(tree.getGroupHeader(), this.nesting);
            }
            ++this.nesting;
            super.visitNonCapturingGroup(tree);
            --this.nesting;
        }
    }

    @Override
    public void visitLookAround(LookAroundTree tree) {
        this.increaseComplexity(tree.getGroupHeader(), this.nesting);
        ++this.nesting;
        super.visitLookAround(tree);
        --this.nesting;
    }

    @Override
    public void visitBackReference(BackReferenceTree tree) {
        this.increaseComplexity(tree, 1);
    }

    @Override
    protected void after(RegexParseResult regexParseResult) {
        if (this.complexity > this.max) {
            int cost = this.complexity - this.max;
            this.regexElementIssueReporter.report(regexParseResult.openingQuote(), String.format(MESSAGE, this.complexity, this.max), cost, this.components);
        }
    }
}

