/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.ImportDeclarationTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.PackageDeclarationTree;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.visitors.TreeContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class StatementsVisitor
extends TreeVisitor<TreeContext> {
    private int statements;

    public StatementsVisitor() {
        this.register(BlockTree.class, (ctx, tree) -> tree.statementOrExpressions().forEach(stmt -> {
            if (!StatementsVisitor.isDeclaration(stmt)) {
                ++this.statements;
            }
        }));
        this.register(TopLevelTree.class, (ctx, tree) -> tree.declarations().forEach(decl -> {
            if (!(StatementsVisitor.isDeclaration(decl) || StatementsVisitor.isNative(decl) || StatementsVisitor.isBlock(decl))) {
                ++this.statements;
            }
        }));
    }

    public int statements(Tree tree) {
        this.statements = 0;
        this.scan(new TreeContext(), tree);
        return this.statements;
    }

    @Override
    protected void before(TreeContext ctx, Tree root) {
        this.statements = 0;
    }

    private static boolean isDeclaration(Tree tree) {
        return tree instanceof ClassDeclarationTree || tree instanceof FunctionDeclarationTree || tree instanceof PackageDeclarationTree || tree instanceof ImportDeclarationTree;
    }

    private static boolean isNative(Tree tree) {
        return tree instanceof NativeTree;
    }

    private static boolean isBlock(Tree tree) {
        return tree instanceof BlockTree;
    }
}

