/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sshd.common.util.functors.UnaryEquator;

public final class GenericUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Object NULL = new Object();
    public static final Comparator<String> CASE_SENSITIVE_ORDER = (s1, s2) -> {
        if (s1 == s2) {
            return 0;
        }
        return s1.compareTo((String)s2);
    };
    public static final String QUOTES = "\"'";

    private GenericUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String trimToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static String replaceWhitespaceAndTrim(String s) {
        if (s != null) {
            s = s.replace('\t', ' ');
        }
        return GenericUtils.trimToEmpty(s);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        int start = 0;
        StringBuilder buf = new StringBuilder(text.length());
        int end = text.indexOf(repl, start);
        while (end != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
            end = text.indexOf(repl, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static int hashCode(String s) {
        return GenericUtils.hashCode(s, null);
    }

    public static int hashCode(String s, Boolean useUppercase) {
        if (GenericUtils.isEmpty(s)) {
            return 0;
        }
        if (useUppercase == null) {
            return s.hashCode();
        }
        if (useUppercase.booleanValue()) {
            return s.toUpperCase().hashCode();
        }
        return s.toLowerCase().hashCode();
    }

    public static int safeCompare(String s1, String s2, boolean caseSensitive) {
        if (UnaryEquator.isSameReference(s1, s2)) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        if (caseSensitive) {
            return s1.compareTo(s2);
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return GenericUtils.length(cs) <= 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !GenericUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        int n = strLen = cs != null ? cs.length() : 0;
        if (cs == null || strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !GenericUtils.isBlank(cs);
    }

    public static List<String> filterToNotBlank(List<String> values2) {
        return values2.stream().filter(GenericUtils::isNotBlank).collect(Collectors.toList());
    }

    public static int indexOf(CharSequence cs, char c) {
        int len = GenericUtils.length(cs);
        for (int pos = 0; pos < len; ++pos) {
            char ch = cs.charAt(pos);
            if (ch != c) continue;
            return pos;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence cs, char c) {
        int len = GenericUtils.length(cs);
        for (int pos = len - 1; pos >= 0; --pos) {
            char ch = cs.charAt(pos);
            if (ch != c) continue;
            return pos;
        }
        return -1;
    }

    public static String[] split(String s, char ch) {
        String v;
        if (GenericUtils.isEmpty(s)) {
            return EMPTY_STRING_ARRAY;
        }
        int lastPos = 0;
        int curPos = s.indexOf(ch);
        if (curPos < 0) {
            return new String[]{s};
        }
        LinkedList<String> values2 = new LinkedList<String>();
        do {
            v = s.substring(lastPos, curPos);
            values2.add(v);
            lastPos = curPos + 1;
        } while (lastPos < s.length() && (curPos = s.indexOf(ch, lastPos)) >= lastPos && curPos < s.length());
        if (lastPos < s.length()) {
            v = s.substring(lastPos);
            values2.add(v);
        }
        return values2.toArray(new String[values2.size()]);
    }

    public static <T> String join(T[] values2, char ch) {
        return GenericUtils.join(GenericUtils.isEmpty(values2) ? Collections.emptyList() : Arrays.asList(values2), ch);
    }

    public static String join(Iterable<?> iter, char ch) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), ch);
    }

    public static String join(Iterator<?> iter, char ch) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(ch);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static <T> String join(T[] values2, CharSequence sep) {
        return GenericUtils.join(GenericUtils.isEmpty(values2) ? Collections.emptyList() : Arrays.asList(values2), sep);
    }

    public static String join(Iterable<?> iter, CharSequence sep) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), sep);
    }

    public static String join(Iterator<?> iter, CharSequence sep) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static boolean isEmpty(Collection<?> c) {
        return GenericUtils.size(c) <= 0;
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return !GenericUtils.isEmpty(c);
    }

    public static <T> boolean equals(Collection<T> c1, Collection<T> c2) {
        if (GenericUtils.isEmpty(c1)) {
            return GenericUtils.isEmpty(c2);
        }
        if (GenericUtils.isEmpty(c2)) {
            return false;
        }
        return c1.size() == c2.size() && c1.containsAll(c2) && c2.containsAll(c1);
    }

    @SafeVarargs
    public static <T> int length(T ... a) {
        return a == null ? 0 : a.length;
    }

    public static <T> boolean isEmpty(Iterable<? extends T> iter) {
        if (iter == null) {
            return true;
        }
        if (iter instanceof Collection) {
            return GenericUtils.isEmpty((Collection)iter);
        }
        return GenericUtils.isEmpty(iter.iterator());
    }

    public static <T> boolean isNotEmpty(Iterable<? extends T> iter) {
        return !GenericUtils.isEmpty(iter);
    }

    public static <T> boolean isEmpty(Iterator<? extends T> iter) {
        return iter == null || !iter.hasNext();
    }

    public static <T> boolean isNotEmpty(Iterator<? extends T> iter) {
        return !GenericUtils.isEmpty(iter);
    }

    public static <T> boolean isEmpty(T[] a) {
        return GenericUtils.length(a) <= 0;
    }

    public static int length(char[] chars) {
        return chars == null ? 0 : chars.length;
    }

    public static boolean isEmpty(char[] chars) {
        return GenericUtils.length(chars) <= 0;
    }

    public static int compare(char[] c1, char[] c2) {
        int l1 = GenericUtils.length(c1);
        int l2 = GenericUtils.length(c2);
        int cmpLen = Math.min(l1, l2);
        for (int index = 0; index < cmpLen; ++index) {
            char c11 = c1[index];
            char c22 = c2[index];
            int nRes = Character.compare(c11, c22);
            if (nRes == 0) continue;
            return nRes;
        }
        int nRes = Integer.compare(l1, l2);
        if (nRes != 0) {
            return nRes;
        }
        return 0;
    }

    @SafeVarargs
    public static <E extends Enum<E>> Set<E> of(E ... values2) {
        return GenericUtils.of(GenericUtils.isEmpty(values2) ? Collections.emptySet() : Arrays.asList(values2));
    }

    public static <E extends Enum<E>> Set<E> of(Collection<? extends E> values2) {
        if (GenericUtils.isEmpty(values2)) {
            return Collections.emptySet();
        }
        EnumSet<Enum> result = null;
        for (Enum v : values2) {
            if (result == null) {
                result = EnumSet.of(v);
                continue;
            }
            result.add(v);
        }
        return result;
    }

    public static <T> int findFirstDifferentValueIndex(List<? extends T> c1, List<? extends T> c2) {
        return GenericUtils.findFirstDifferentValueIndex(c1, c2, UnaryEquator.defaultEquality());
    }

    public static <T> int findFirstDifferentValueIndex(List<? extends T> c1, List<? extends T> c2, UnaryEquator<? super T> equator) {
        Objects.requireNonNull(equator, "No equator provided");
        int l1 = GenericUtils.size(c1);
        int l2 = GenericUtils.size(c2);
        int count = Math.min(l1, l2);
        for (int index = 0; index < count; ++index) {
            T v2;
            T v1 = c1.get(index);
            if (equator.test(v1, v2 = c2.get(index))) continue;
            return index;
        }
        if (l1 < l2) {
            return l1;
        }
        if (l2 < l1) {
            return l2;
        }
        return -1;
    }

    public static <T> int findFirstDifferentValueIndex(Iterable<? extends T> c1, Iterable<? extends T> c2) {
        return GenericUtils.findFirstDifferentValueIndex(c1, c2, UnaryEquator.defaultEquality());
    }

    public static <T> int findFirstDifferentValueIndex(Iterable<? extends T> c1, Iterable<? extends T> c2, UnaryEquator<? super T> equator) {
        return GenericUtils.findFirstDifferentValueIndex(GenericUtils.iteratorOf(c1), GenericUtils.iteratorOf(c2), equator);
    }

    public static <T> int findFirstDifferentValueIndex(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        return GenericUtils.findFirstDifferentValueIndex(i1, i2, UnaryEquator.defaultEquality());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> int findFirstDifferentValueIndex(Iterator<? extends T> i1, Iterator<? extends T> i2, UnaryEquator<? super T> equator) {
        Objects.requireNonNull(equator, "No equator provided");
        i1 = GenericUtils.iteratorOf(i1);
        i2 = GenericUtils.iteratorOf(i2);
        int index = 0;
        while (true) {
            if (i1.hasNext()) {
                T v2;
                if (!i2.hasNext()) return index;
                T v1 = i1.next();
                if (!equator.test(v1, v2 = i2.next())) {
                    return index;
                }
            } else {
                if (!i2.hasNext()) return -1;
                return index;
            }
            ++index;
        }
    }

    public static <T> boolean containsAny(Collection<? extends T> coll, Iterable<? extends T> values2) {
        if (GenericUtils.isEmpty(coll)) {
            return false;
        }
        for (T v : values2) {
            if (!coll.contains(v)) continue;
            return true;
        }
        return false;
    }

    public static <T> void forEach(Iterable<? extends T> values2, Consumer<? super T> consumer) {
        if (GenericUtils.isNotEmpty(values2)) {
            values2.forEach(consumer);
        }
    }

    public static <T, U> List<U> map(Collection<? extends T> values2, Function<? super T, ? extends U> mapper) {
        return GenericUtils.stream(values2).map(mapper).collect(Collectors.toList());
    }

    public static <T, U> NavigableSet<U> mapSort(Collection<? extends T> values2, Function<? super T, ? extends U> mapper, Comparator<? super U> comparator) {
        return GenericUtils.stream(values2).map(mapper).collect(GenericUtils.toSortedSet(comparator));
    }

    public static <T> Collector<T, ?, NavigableSet<T>> toSortedSet(Comparator<? super T> comparator) {
        return Collectors.toCollection(() -> new TreeSet(comparator));
    }

    public static <T> Stream<T> stream(Iterable<T> values2) {
        if (GenericUtils.isEmpty(values2)) {
            return Stream.empty();
        }
        if (values2 instanceof Collection) {
            return ((Collection)values2).stream();
        }
        return StreamSupport.stream(values2.spliterator(), false);
    }

    @SafeVarargs
    public static <T> List<T> unmodifiableList(T ... values2) {
        return GenericUtils.unmodifiableList(GenericUtils.asList(values2));
    }

    public static <T> List<T> unmodifiableList(Collection<? extends T> values2) {
        if (GenericUtils.isEmpty(values2)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(values2));
    }

    public static <T> List<T> unmodifiableList(Stream<T> values2) {
        return GenericUtils.unmodifiableList(values2.collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... values2) {
        return GenericUtils.isEmpty(values2) ? Collections.emptyList() : Arrays.asList(values2);
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... values2) {
        return new HashSet<T>(GenericUtils.asList(values2));
    }

    @SafeVarargs
    public static <V extends Comparable<V>> NavigableSet<V> asSortedSet(V ... values2) {
        return GenericUtils.asSortedSet(Comparator.naturalOrder(), values2);
    }

    public static <V extends Comparable<V>> NavigableSet<V> asSortedSet(Collection<? extends V> values2) {
        return GenericUtils.asSortedSet(Comparator.naturalOrder(), values2);
    }

    @SafeVarargs
    public static <V> NavigableSet<V> asSortedSet(Comparator<? super V> comp, V ... values2) {
        return GenericUtils.asSortedSet(comp, GenericUtils.isEmpty(values2) ? Collections.emptyList() : Arrays.asList(values2));
    }

    public static <V> NavigableSet<V> asSortedSet(Comparator<? super V> comp, Collection<? extends V> values2) {
        TreeSet<V> set = new TreeSet<V>(Objects.requireNonNull(comp, "No comparator"));
        if (GenericUtils.size(values2) > 0) {
            set.addAll(values2);
        }
        return set;
    }

    @SafeVarargs
    public static <T> T findFirstMatchingMember(Predicate<? super T> acceptor, T ... values2) {
        return GenericUtils.findFirstMatchingMember(acceptor, GenericUtils.isEmpty(values2) ? Collections.emptyList() : Arrays.asList(values2));
    }

    public static <T> T findFirstMatchingMember(Predicate<? super T> acceptor, Collection<? extends T> values2) {
        List<? extends T> matches = GenericUtils.selectMatchingMembers(acceptor, values2);
        return GenericUtils.isEmpty(matches) ? null : (T)matches.get(0);
    }

    @SafeVarargs
    public static <T> List<T> selectMatchingMembers(Predicate<? super T> acceptor, T ... values2) {
        return GenericUtils.selectMatchingMembers(acceptor, GenericUtils.isEmpty(values2) ? Collections.emptyList() : Arrays.asList(values2));
    }

    public static <T> List<T> selectMatchingMembers(Predicate<? super T> acceptor, Collection<? extends T> values2) {
        return GenericUtils.stream(values2).filter(acceptor).collect(Collectors.toList());
    }

    public static CharSequence stripQuotes(CharSequence s) {
        if (GenericUtils.isEmpty(s)) {
            return s;
        }
        for (int index = 0; index < QUOTES.length(); ++index) {
            char delim = QUOTES.charAt(index);
            CharSequence v = GenericUtils.stripDelimiters(s, delim);
            if (v == s) continue;
            return v;
        }
        return s;
    }

    public static CharSequence stripDelimiters(CharSequence s, char delim) {
        if (GenericUtils.isEmpty(s) || s.length() < 2) {
            return s;
        }
        int lastPos = s.length() - 1;
        if (s.charAt(0) != delim || s.charAt(lastPos) != delim) {
            return s;
        }
        return s.subSequence(1, lastPos);
    }

    public static <T> Supplier<T> supplierOf(T value) {
        return () -> value;
    }

    public static <T> Iterator<T> iteratorOf(Iterable<T> iterable) {
        return GenericUtils.iteratorOf(iterable == null ? null : iterable.iterator());
    }

    public static <B, D extends B> Function<D, B> downcast() {
        return t -> t;
    }

    public static <T> T head(Iterable<? extends T> it) {
        if (it == null) {
            return null;
        }
        if (it instanceof Deque) {
            Deque l = (Deque)it;
            return !l.isEmpty() ? (T)l.getFirst() : null;
        }
        if (it instanceof List) {
            List l = (List)it;
            return !l.isEmpty() ? (T)l.get(0) : null;
        }
        if (it instanceof SortedSet) {
            SortedSet s = (SortedSet)it;
            return !s.isEmpty() ? (T)s.first() : null;
        }
        Iterator<T> iter = it.iterator();
        return iter == null || !iter.hasNext() ? null : (T)iter.next();
    }

    public static <T> Iterator<T> iteratorOf(Iterator<T> iter) {
        return iter == null ? Collections.emptyIterator() : iter;
    }

    public static <U, V> Iterable<V> wrapIterable(Iterable<? extends U> iter, Function<? super U, ? extends V> mapper) {
        return () -> GenericUtils.wrapIterator(iter, mapper);
    }

    public static <U, V> Iterator<V> wrapIterator(Iterable<? extends U> iter, Function<? super U, ? extends V> mapper) {
        return GenericUtils.stream(iter).map(mapper).iterator();
    }

    public static <U, V> Iterator<V> wrapIterator(Iterator<? extends U> iter, final Function<? super U, ? extends V> mapper) {
        final Iterator<? extends U> iterator2 = GenericUtils.iteratorOf(iter);
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public V next() {
                Object value = iterator2.next();
                return mapper.apply(value);
            }
        };
    }

    public static <T> T selectNextMatchingValue(Iterator<?> values2, Class<T> type) {
        Objects.requireNonNull(type, "No type selector specified");
        if (values2 == null) {
            return null;
        }
        while (values2.hasNext()) {
            Class<?> t;
            Object o = values2.next();
            if (o == null || !type.isAssignableFrom(t = o.getClass())) continue;
            return type.cast(o);
        }
        return null;
    }

    public static <T> Iterable<T> multiIterableSuppliers(Iterable<? extends Supplier<? extends Iterable<? extends T>>> providers) {
        return () -> GenericUtils.stream(providers).flatMap(s -> GenericUtils.stream((Iterable)s.get())).map(Function.identity()).iterator();
    }

    public static <T> Supplier<T> memoizeLock(Supplier<? extends T> delegate) {
        AtomicReference value = new AtomicReference();
        return () -> {
            Object val = value.get();
            if (val == null) {
                AtomicReference atomicReference = value;
                synchronized (atomicReference) {
                    val = value.get();
                    if (val == null) {
                        val = Objects.requireNonNull(delegate.get());
                        value.set(val);
                    }
                }
            }
            return val;
        };
    }

    public static boolean isPositive(Duration d) {
        return !GenericUtils.isNegativeOrNull(d);
    }

    public static boolean isNegativeOrNull(Duration d) {
        return d.isNegative() || d.isZero();
    }
}

