/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.jgit.hooks.CommitMsgHook;
import org.eclipse.jgit.hooks.PostCommitHook;
import org.eclipse.jgit.hooks.PreCommitHook;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.LfsFactory;

public class Hooks {
    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream2) {
        return new PreCommitHook(repo, outputStream2);
    }

    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream2, PrintStream errorStream) {
        return new PreCommitHook(repo, outputStream2, errorStream);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream2) {
        return new PostCommitHook(repo, outputStream2);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream2, PrintStream errorStream) {
        return new PostCommitHook(repo, outputStream2, errorStream);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream2) {
        return new CommitMsgHook(repo, outputStream2);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream2, PrintStream errorStream) {
        return new CommitMsgHook(repo, outputStream2, errorStream);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream2) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream2)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream2;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream2);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream2, PrintStream errorStream) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream2, errorStream)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream2;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream2, errorStream);
    }
}

