/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.cpd.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.cpd.internal.TokensLine;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.utils.Preconditions;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class DefaultCpdTokens
extends DefaultStorable
implements NewCpdTokens {
    private static final Logger LOG = Loggers.get(DefaultCpdTokens.class);
    private final List<TokensLine> result = new ArrayList<TokensLine>();
    private DefaultInputFile inputFile;
    private int startLine = Integer.MIN_VALUE;
    private int startIndex = 0;
    private int currentIndex = 0;
    private StringBuilder sb = new StringBuilder();
    private TextRange lastRange;
    private boolean loggedTestCpdWarning = false;

    public DefaultCpdTokens(SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultCpdTokens onFile(InputFile inputFile) {
        this.inputFile = (DefaultInputFile)Objects.requireNonNull(inputFile, "file can't be null");
        return this;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public NewCpdTokens addToken(int startLine, int startLineOffset, int endLine, int endLineOffset, String image) {
        TextRange newRange;
        this.checkInputFileNotNull();
        try {
            newRange = this.inputFile.newRange(startLine, startLineOffset, endLine, endLineOffset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to register token in file " + this.inputFile, e);
        }
        return this.addToken(newRange, image);
    }

    @Override
    public DefaultCpdTokens addToken(TextRange range, String image) {
        Objects.requireNonNull(range, "Range should not be null");
        Objects.requireNonNull(image, "Image should not be null");
        this.checkInputFileNotNull();
        if (this.isExcludedForDuplication()) {
            return this;
        }
        Preconditions.checkState(this.lastRange == null || this.lastRange.end().compareTo(range.start()) <= 0, "Tokens of file %s should be provided in order.\nPrevious token: %s\nLast token: %s", this.inputFile, this.lastRange, range);
        int line = range.start().line();
        if (line != this.startLine) {
            DefaultCpdTokens.addNewTokensLine(this.result, this.startIndex, this.currentIndex, this.startLine, this.sb);
            this.startIndex = this.currentIndex + 1;
            this.startLine = line;
        }
        ++this.currentIndex;
        this.sb.append(image);
        this.lastRange = range;
        return this;
    }

    private boolean isExcludedForDuplication() {
        if (this.inputFile.isExcludedForDuplication()) {
            return true;
        }
        if (this.inputFile.type() == InputFile.Type.TEST) {
            if (!this.loggedTestCpdWarning) {
                LOG.warn("Duplication reported for '{}' will be ignored because it's a test file.", (Object)this.inputFile);
                this.loggedTestCpdWarning = true;
            }
            return true;
        }
        return false;
    }

    public List<TokensLine> getTokenLines() {
        return Collections.unmodifiableList(new ArrayList<TokensLine>(this.result));
    }

    private static void addNewTokensLine(List<TokensLine> result, int startUnit, int endUnit, int startLine, StringBuilder sb) {
        if (sb.length() != 0) {
            result.add(new TokensLine(startUnit, endUnit, startLine, sb.toString()));
            sb.setLength(0);
        }
    }

    @Override
    protected void doSave() {
        Preconditions.checkState(this.inputFile != null, "Call onFile() first");
        if (this.isExcludedForDuplication()) {
            return;
        }
        DefaultCpdTokens.addNewTokensLine(this.result, this.startIndex, this.currentIndex, this.startLine, this.sb);
        this.storage.store(this);
    }

    private void checkInputFileNotNull() {
        Preconditions.checkState(this.inputFile != null, "Call onFile() first");
    }
}

