/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public abstract class AbstractExclusionFilters {
    private static final Logger LOG = Loggers.get(AbstractExclusionFilters.class);
    private static final String WARNING_ALIAS_PROPERTY_USAGE = "Use of %s detected. While being taken into account, the only supported property is %s. Consider updating your configuration.";
    private static final String WARNING_LEGACY_AND_ALIAS_PROPERTIES_USAGE = "Use of %s and %s at the same time. %s is taken into account. Consider updating your configuration";
    private final AnalysisWarnings analysisWarnings;
    private final String[] sourceInclusions;
    private final String[] testInclusions;
    private final String[] sourceExclusions;
    private final String[] testExclusions;
    private PathPattern[] mainInclusionsPattern;
    private PathPattern[] mainExclusionsPattern;
    private PathPattern[] testInclusionsPattern;
    private PathPattern[] testExclusionsPattern;

    protected AbstractExclusionFilters(AnalysisWarnings analysisWarnings, Function<String, String[]> configProvider) {
        this.analysisWarnings = analysisWarnings;
        this.sourceInclusions = this.inclusions(configProvider, "sonar.inclusions");
        this.sourceExclusions = this.exclusions(configProvider, "sonar.global.exclusions", "sonar.exclusions");
        String[] testInclusionsFromLegacy = this.inclusions(configProvider, "sonar.test.inclusions");
        String[] testInclusionsFromAlias = this.inclusions(configProvider, "sonar.tests.inclusions");
        this.testInclusions = this.keepInclusionTestBetweenLegacyAndAliasProperties(testInclusionsFromLegacy, testInclusionsFromAlias);
        String[] testExclusionsFromLegacy = this.exclusions(configProvider, "sonar.global.test.exclusions", "sonar.test.exclusions");
        String[] testExclusionsFromAlias = this.exclusions(configProvider, "sonar.global.test.exclusions", "sonar.tests.exclusions");
        this.testExclusions = this.keepExclusionTestBetweenLegacyAndAliasProperties(testExclusionsFromLegacy, testExclusionsFromAlias);
        this.mainInclusionsPattern = AbstractExclusionFilters.prepareMainInclusions(this.sourceInclusions);
        this.mainExclusionsPattern = AbstractExclusionFilters.prepareMainExclusions(this.sourceExclusions, this.testInclusions);
        this.testInclusionsPattern = AbstractExclusionFilters.prepareTestInclusions(this.testInclusions);
        this.testExclusionsPattern = AbstractExclusionFilters.prepareTestExclusions(this.testExclusions);
    }

    private String[] keepExclusionTestBetweenLegacyAndAliasProperties(String[] fromLegacyProperty, String[] fromAliasProperty) {
        if (fromAliasProperty.length == 0) {
            return fromLegacyProperty;
        }
        if (fromLegacyProperty.length == 0) {
            this.logWarningForAliasUsage("sonar.test.exclusions", "sonar.tests.exclusions");
            return fromAliasProperty;
        }
        this.logWarningForLegacyAndAliasUsage("sonar.test.exclusions", "sonar.tests.exclusions");
        return fromLegacyProperty;
    }

    private String[] keepInclusionTestBetweenLegacyAndAliasProperties(String[] fromLegacyProperty, String[] fromAliasProperty) {
        if (fromAliasProperty.length == 0) {
            return fromLegacyProperty;
        }
        if (fromLegacyProperty.length == 0) {
            this.logWarningForAliasUsage("sonar.test.inclusions", "sonar.tests.inclusions");
            return fromAliasProperty;
        }
        this.logWarningForLegacyAndAliasUsage("sonar.test.inclusions", "sonar.tests.inclusions");
        return fromLegacyProperty;
    }

    private void logWarningForAliasUsage(String legacyProperty, String aliasProperty) {
        this.logWarning(String.format(WARNING_ALIAS_PROPERTY_USAGE, aliasProperty, legacyProperty));
    }

    private void logWarningForLegacyAndAliasUsage(String legacyProperty, String aliasProperty) {
        this.logWarning(String.format(WARNING_LEGACY_AND_ALIAS_PROPERTIES_USAGE, legacyProperty, aliasProperty, legacyProperty));
    }

    private void logWarning(String warning) {
        LOG.warn(warning);
        this.analysisWarnings.addUnique(warning);
    }

    public void log(String indent) {
        AbstractExclusionFilters.log("Included sources:", this.mainInclusionsPattern, indent);
        AbstractExclusionFilters.log("Excluded sources:", this.mainExclusionsPattern, indent);
        AbstractExclusionFilters.log("Included tests:", this.testInclusionsPattern, indent);
        AbstractExclusionFilters.log("Excluded tests:", this.testExclusionsPattern, indent);
    }

    private String[] inclusions(Function<String, String[]> configProvider, String propertyKey) {
        return (String[])Arrays.stream(configProvider.apply(propertyKey)).map(StringUtils::trim).filter(s -> !"**/*".equals(s)).filter(s -> !"file:**/*".equals(s)).toArray(String[]::new);
    }

    private String[] exclusions(Function<String, String[]> configProvider, String globalExclusionsProperty, String exclusionsProperty) {
        String[] globalExclusions = configProvider.apply(globalExclusionsProperty);
        String[] exclusions = configProvider.apply(exclusionsProperty);
        return (String[])Stream.concat(Arrays.stream(globalExclusions), Arrays.stream(exclusions)).map(StringUtils::trim).toArray(String[]::new);
    }

    public boolean hasPattern() {
        return this.mainInclusionsPattern.length > 0 || this.mainExclusionsPattern.length > 0 || this.testInclusionsPattern.length > 0 || this.testExclusionsPattern.length > 0;
    }

    private static void log(String title, PathPattern[] patterns, String indent) {
        if (patterns.length > 0) {
            LOG.info("{}{} {}", indent, title, Arrays.stream(patterns).map(Object::toString).collect(Collectors.joining(", ")));
        }
    }

    private static PathPattern[] prepareMainInclusions(String[] sourceInclusions) {
        if (sourceInclusions.length > 0) {
            return PathPattern.create(sourceInclusions);
        }
        return new PathPattern[0];
    }

    private static PathPattern[] prepareTestInclusions(String[] testInclusions) {
        return PathPattern.create(testInclusions);
    }

    static PathPattern[] prepareMainExclusions(String[] sourceExclusions, String[] testInclusions) {
        String[] patterns = (String[])ArrayUtils.addAll(sourceExclusions, testInclusions);
        return PathPattern.create(patterns);
    }

    private static PathPattern[] prepareTestExclusions(String[] testExclusions) {
        return PathPattern.create(testExclusions);
    }

    public String[] getInclusionsConfig(InputFile.Type type) {
        return type == InputFile.Type.MAIN ? this.sourceInclusions : this.testInclusions;
    }

    public String[] getExclusionsConfig(InputFile.Type type) {
        return type == InputFile.Type.MAIN ? this.sourceExclusions : this.testExclusions;
    }

    public boolean isIncluded(Path absolutePath, Path relativePath, InputFile.Type type) {
        PathPattern[] inclusionPatterns;
        PathPattern[] pathPatternArray = inclusionPatterns = InputFile.Type.MAIN == type ? this.mainInclusionsPattern : this.testInclusionsPattern;
        if (inclusionPatterns.length == 0) {
            return true;
        }
        for (PathPattern pattern : inclusionPatterns) {
            if (!pattern.match(absolutePath, relativePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(Path absolutePath, Path relativePath, InputFile.Type type) {
        PathPattern[] exclusionPatterns;
        for (PathPattern pattern : exclusionPatterns = InputFile.Type.MAIN == type ? this.mainExclusionsPattern : this.testExclusionsPattern) {
            if (!pattern.match(absolutePath, relativePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedAsParentDirectoryOfExcludedChildren(Path absolutePath, Path relativePath, Path baseDir, InputFile.Type type) {
        PathPattern[] exclusionPatterns = InputFile.Type.MAIN == type ? this.mainExclusionsPattern : this.testExclusionsPattern;
        return Stream.of(exclusionPatterns).map(Object::toString).filter(ps -> ps.endsWith("/**/*")).map(ps -> ps.substring(0, ps.length() - 5)).map(baseDir::resolve).anyMatch(exclusionRootPath -> absolutePath.startsWith((Path)exclusionRootPath) || PathPattern.create(exclusionRootPath.toString()).match(absolutePath, relativePath));
    }
}

