/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.source;

import java.util.Set;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.scanner.report.ReportPublisher;

@Phase(name=Phase.Name.POST)
public final class ZeroCoverageSensor
implements ProjectSensor {
    private final ReportPublisher reportPublisher;

    public ZeroCoverageSensor(ReportPublisher reportPublisher) {
        this.reportPublisher = reportPublisher;
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Zero Coverage Sensor");
    }

    @Override
    public void execute(SensorContext context) {
        FileSystem fs = context.fileSystem();
        for (InputFile f : fs.inputFiles(fs.predicates().hasType(InputFile.Type.MAIN))) {
            if (((DefaultInputFile)f).isExcludedForCoverage() || this.isCoverageAlreadyDefined(f)) continue;
            ((DefaultInputFile)f).getExecutableLines().ifPresent(execLines -> ZeroCoverageSensor.storeZeroCoverageForEachExecutableLine(context, f, execLines));
        }
    }

    private static void storeZeroCoverageForEachExecutableLine(SensorContext context, InputFile f, Set<Integer> executableLines) {
        NewCoverage newCoverage = context.newCoverage().onFile(f);
        for (Integer lineIdx : executableLines) {
            if (lineIdx > f.lines()) continue;
            newCoverage.lineHits(lineIdx, 0);
        }
        newCoverage.save();
    }

    private boolean isCoverageAlreadyDefined(InputFile f) {
        return this.reportPublisher.getReader().hasCoverage(((DefaultInputFile)f).scannerId());
    }
}

