/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.CheckUtils;

public abstract class AbstractDuplicateKeyCheck
extends PythonSubscriptionCheck {
    static final int SIZE_THRESHOLD = 100;

    boolean isSameKey(Expression key, Expression comparedKey) {
        if (key.is(Tree.Kind.TUPLE) && comparedKey.is(Tree.Kind.TUPLE)) {
            return this.areEquivalentTuples((Tuple)key, (Tuple)comparedKey);
        }
        if (key.is(Tree.Kind.STRING_LITERAL) && comparedKey.is(Tree.Kind.STRING_LITERAL)) {
            return AbstractDuplicateKeyCheck.areEquivalentStringLiterals((StringLiteral)key, (StringLiteral)comparedKey);
        }
        if (AbstractDuplicateKeyCheck.isANumber(key) && AbstractDuplicateKeyCheck.isANumber(comparedKey)) {
            return this.areEquivalentNumbers(key, comparedKey);
        }
        return !key.is(Tree.Kind.CALL_EXPR) && CheckUtils.areEquivalent(key, comparedKey);
    }

    private boolean areEquivalentTuples(Tuple key, Tuple comparedKey) {
        List<Expression> first = key.elements();
        List<Expression> second = comparedKey.elements();
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (this.isSameKey(first.get(i), second.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean areEquivalentNumbers(Tree key, Tree comparedKey) {
        return AbstractDuplicateKeyCheck.toNumber(key).isEquivalentNumber(AbstractDuplicateKeyCheck.toNumber(comparedKey));
    }

    private static Number toNumber(Tree numberTree) {
        if (numberTree.is(Tree.Kind.NUMERIC_LITERAL)) {
            return Number.fromString(((NumericLiteral)numberTree).valueAsString());
        }
        return "True".equals(((Name)numberTree).name()) ? new Number(BigDecimal.ONE) : new Number(BigDecimal.ZERO);
    }

    private static boolean areEquivalentStringLiterals(StringLiteral key, StringLiteral comparedKey) {
        if (key.stringElements().stream().anyMatch(StringElement::isInterpolated) || comparedKey.stringElements().stream().anyMatch(StringElement::isInterpolated)) {
            return false;
        }
        if (key.trimmedQuotesValue().equals(comparedKey.trimmedQuotesValue())) {
            String keyWithPrefixes = key.stringElements().stream().map(s -> s.prefix().toLowerCase(Locale.ENGLISH) + s.trimmedQuotesValue()).collect(Collectors.joining());
            String comparedKeyWithPrefixes = comparedKey.stringElements().stream().map(s -> s.prefix().toLowerCase(Locale.ENGLISH) + s.trimmedQuotesValue()).collect(Collectors.joining());
            return keyWithPrefixes.equals(comparedKeyWithPrefixes);
        }
        return false;
    }

    private static boolean isANumber(Tree tree) {
        return tree.is(Tree.Kind.NUMERIC_LITERAL) || tree.is(Tree.Kind.NAME) && ("True".equals(((Name)tree).name()) || "False".equals(((Name)tree).name()));
    }

    static class Number {
        private final boolean isComplex;
        private final BigDecimal value;

        public Number(BigDecimal value, boolean isComplex) {
            this.value = value;
            this.isComplex = isComplex;
        }

        public Number(BigDecimal value) {
            this.value = value;
            this.isComplex = false;
        }

        public static Number fromString(String str) {
            String numberValue = str.replace("_", "");
            if (numberValue.endsWith("L") || numberValue.endsWith("l")) {
                numberValue = numberValue.substring(0, numberValue.length() - 1);
            }
            if (numberValue.startsWith("0b") || numberValue.startsWith("0B")) {
                return new Number(new BigDecimal(new BigInteger(numberValue.substring(2), 2)));
            }
            if (numberValue.startsWith("0o") || numberValue.startsWith("0O")) {
                return new Number(new BigDecimal(new BigInteger(numberValue.substring(2), 8)));
            }
            if (numberValue.startsWith("0x") || numberValue.startsWith("0X")) {
                return new Number(new BigDecimal(new BigInteger(numberValue.substring(2), 16)));
            }
            if (numberValue.endsWith("j") || numberValue.endsWith("J")) {
                return new Number(new BigDecimal(new BigInteger(numberValue.substring(0, numberValue.length() - 1))), true);
            }
            return new Number(new BigDecimal(numberValue));
        }

        public boolean isEquivalentNumber(Number other) {
            if (other.value.compareTo(BigDecimal.ZERO) == 0 && this.value.compareTo(BigDecimal.ZERO) == 0) {
                return true;
            }
            if (other.isComplex != this.isComplex) {
                return false;
            }
            return other.value.compareTo(this.value) == 0;
        }
    }
}

