/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.quickfix.PythonQuickFix;
import org.sonar.python.quickfix.PythonTextEdit;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S4144")
public class DuplicatedMethodImplementationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Update this function so that its implementation is not identical to %s on line %s.";
    private static final String QUICK_FIX_MESSAGE = "Call %s inside this function.";
    private static final Set<String> ALLOWED_FIRST_ARG_NAMES = Set.of("self", "cls", "mcs", "metacls");
    private static final Set<String> CLASS_AND_STATIC_DECORATORS = Set.of("classmethod", "staticmethod");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            MethodVisitor methodVisitor = new MethodVisitor();
            classDef.body().accept(methodVisitor);
            for (int i = 1; i < methodVisitor.methods.size(); ++i) {
                DuplicatedMethodImplementationCheck.checkMethods(methodVisitor.methods.get(i), methodVisitor.methods, i, ctx);
            }
        });
    }

    private static void checkMethods(FunctionDef suspiciousMethod, List<FunctionDef> methods, int index, SubscriptionContext ctx) {
        StatementList suspiciousBody = suspiciousMethod.body();
        if (DuplicatedMethodImplementationCheck.isException(suspiciousMethod)) {
            return;
        }
        for (int j = 0; j < index; ++j) {
            FunctionDef originalMethod = methods.get(j);
            StatementList originalBody = originalMethod.body();
            if (!CheckUtils.areEquivalent(originalBody, suspiciousBody)) continue;
            int line = originalMethod.name().firstToken().line();
            String message = String.format(MESSAGE, originalMethod.name().name(), line);
            PythonCheck.PreciseIssue issue = ctx.addIssue(suspiciousMethod.name(), message).secondary(originalMethod.name(), "Original");
            DuplicatedMethodImplementationCheck.addQuickFix((IssueWithQuickFix)issue, originalMethod, suspiciousMethod);
            break;
        }
    }

    private static boolean isException(FunctionDef suspiciousMethod) {
        int nbActualStatements;
        boolean hasDocString = suspiciousMethod.docstring() != null;
        StatementList suspiciousBody = suspiciousMethod.body();
        List<Statement> statements = suspiciousBody.statements();
        int n = nbActualStatements = hasDocString ? statements.size() - 1 : statements.size();
        if (nbActualStatements == 0 || DuplicatedMethodImplementationCheck.isOnASingleLine(suspiciousBody, hasDocString)) {
            return true;
        }
        return nbActualStatements == 1 && statements.get(statements.size() - 1).is(Tree.Kind.RAISE_STMT);
    }

    private static boolean isOnASingleLine(StatementList statementList, boolean hasDocString) {
        int first = hasDocString ? 1 : 0;
        return statementList.statements().get(first).firstToken().line() == statementList.statements().get(statementList.statements().size() - 1).lastToken().line();
    }

    private static void addQuickFix(IssueWithQuickFix issue, FunctionDef originalMethod, FunctionDef suspiciousMethod) {
        ParameterList parameters = originalMethod.parameters();
        if (parameters != null) {
            List<AnyParameter> all = parameters.all();
            if (all.size() == 1 && !ALLOWED_FIRST_ARG_NAMES.contains(all.get(0).firstToken().value())) {
                return;
            }
            if (all.size() > 1) {
                return;
            }
        }
        boolean containsReturnStatement = originalMethod.body().statements().stream().anyMatch(s -> s.is(Tree.Kind.RETURN_STMT));
        Object replacementText = "";
        if (containsReturnStatement) {
            replacementText = "return ";
        }
        if (DuplicatedMethodImplementationCheck.isClassOrStaticMethod(originalMethod)) {
            ClassDef methodClass = (ClassDef)TreeUtils.firstAncestorOfKind(originalMethod, Tree.Kind.CLASSDEF);
            if (methodClass != null) {
                replacementText = (String)replacementText + methodClass.name().name() + ".";
            }
        } else {
            replacementText = (String)replacementText + "self.";
        }
        replacementText = (String)replacementText + originalMethod.name().name() + "()";
        PythonTextEdit edit = PythonTextEdit.replace(suspiciousMethod.body(), (String)replacementText);
        PythonQuickFix fix = PythonQuickFix.newQuickFix(String.format(QUICK_FIX_MESSAGE, originalMethod.name().name())).addTextEdit(edit).build();
        issue.addQuickFix(fix);
    }

    private static boolean isClassOrStaticMethod(FunctionDef originalMethod) {
        return originalMethod.decorators().stream().anyMatch(d -> d.expression() instanceof NameImpl && CLASS_AND_STATIC_DECORATORS.contains(((NameImpl)d.expression()).name()));
    }

    private static class MethodVisitor
    extends BaseTreeVisitor {
        List<FunctionDef> methods = new ArrayList<FunctionDef>();

        private MethodVisitor() {
        }

        @Override
        public void visitClassDef(ClassDef classDef) {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            if (functionDef.isMethodDefinition()) {
                this.methods.add(functionDef);
            }
            super.visitFunctionDef(functionDef);
        }
    }
}

