/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S2733")
public class ExitHasBadArgumentsCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_ADD = "Add the missing argument.";
    private static final String MESSAGE_REMOVE = "Remove the unnecessary argument.";
    private static final int EXIT_ARGUMENTS_NUMBER = 4;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef funcDef = (FunctionDef)ctx.syntaxNode();
            if (!funcDef.name().name().equals("__exit__")) {
                return;
            }
            ParameterList parameters = funcDef.parameters();
            int arity = 0;
            if (parameters != null) {
                if (parameters.nonTuple().stream().anyMatch(ExitHasBadArgumentsCheck::isStarredParam)) {
                    return;
                }
                arity = parameters.all().size();
            }
            ExitHasBadArgumentsCheck.raiseIssue(ctx, funcDef, arity);
        });
    }

    private static boolean isStarredParam(Parameter param) {
        return param.starToken() != null;
    }

    private static void raiseIssue(SubscriptionContext ctx, FunctionDef tree, int argumentsNumber) {
        if (argumentsNumber != 4) {
            String message = MESSAGE_ADD;
            if (argumentsNumber > 4) {
                message = MESSAGE_REMOVE;
            }
            Name funcName = tree.name();
            Token rightParenthesis = tree.rightPar();
            ctx.addIssue(funcName.firstToken(), rightParenthesis, message);
        }
    }
}

