/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6333")
public class PublicApiIsSecuritySensitiveCheck
extends AbstractCdkResourceCheck {
    private static final String MESSAGE = "Make sure that creating public APIs is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"authorization_type\" disables authentication. Make sure it is safe here.";
    private static final String AUTHORIZATION_TYPE = "authorization_type";
    private static final String AUTHORIZATION_TYPE_NONE = "aws_cdk.aws_apigateway.AuthorizationType.NONE";
    private final Set<String> safeMethods = new HashSet<String>();

    @Override
    public void scanFile(PythonVisitorContext visitorContext) {
        super.scanFile(visitorContext);
        this.safeMethods.clear();
    }

    @Override
    protected void registerFqnConsumer() {
        this.checkFqns(List.of("aws_cdk.aws_apigateway.CfnMethod", "aws_cdk.aws_apigatewayv2.CfnRoute"), (subscriptionContext, callExpression) -> CdkUtils.getArgument(subscriptionContext, callExpression, AUTHORIZATION_TYPE).ifPresentOrElse(argument -> argument.addIssueIf(CdkPredicate.isString("NONE"), MESSAGE, new IssueLocation[0]), () -> subscriptionContext.addIssue(callExpression.callee(), OMITTING_MESSAGE)));
        this.checkFqns(List.of("aws_cdk.aws_apigateway.RestApi", "aws_cdk.aws_apigateway.Resource.add_resource"), (subscriptionContext, callExpression) -> CdkUtils.getArgument(subscriptionContext, callExpression, "default_method_options").ifPresent(argument -> {
            if (PublicApiIsSecuritySensitiveCheck.isArgumentSafe(subscriptionContext, argument)) {
                PublicApiIsSecuritySensitiveCheck.enclosingMethodFqn(callExpression).ifPresent(this.safeMethods::add);
            }
        }));
        this.checkFqn("aws_cdk.aws_apigateway.Resource.add_method", (subscriptionContext, callExpression) -> CdkUtils.getArgument(subscriptionContext, callExpression, AUTHORIZATION_TYPE).ifPresentOrElse(argument -> argument.addIssueIf(CdkPredicate.isFqn(AUTHORIZATION_TYPE_NONE), MESSAGE, new IssueLocation[0]), () -> PublicApiIsSecuritySensitiveCheck.enclosingMethodFqn(callExpression).filter(fqn -> !this.safeMethods.contains(fqn)).ifPresent(fnq -> subscriptionContext.addIssue(callExpression.callee(), OMITTING_MESSAGE))));
    }

    private static Optional<String> enclosingMethodFqn(Tree tree) {
        FunctionDef functionDef = (FunctionDef)TreeUtils.firstAncestorOfKind(tree, Tree.Kind.FUNCDEF);
        return Optional.ofNullable(functionDef).map(FunctionDefImpl.class::cast).map(FunctionDefImpl::functionSymbol).map(Symbol::fullyQualifiedName);
    }

    private static boolean isArgumentSafe(SubscriptionContext subscriptionContext, CdkUtils.ExpressionFlow argument) {
        return !PublicApiIsSecuritySensitiveCheck.isUnsafeSafeDictionaryAuthorisationKey(subscriptionContext, argument.getLast()) && !PublicApiIsSecuritySensitiveCheck.isUnsafeAuthorisationArgument(subscriptionContext, argument);
    }

    private static boolean isUnsafeSafeDictionaryAuthorisationKey(SubscriptionContext ctx, Expression expression) {
        return CdkUtils.getDictionary(expression).flatMap(dictionary -> CdkUtils.getDictionaryPair(ctx, dictionary, AUTHORIZATION_TYPE)).filter(element -> CdkPredicate.isFqn(AUTHORIZATION_TYPE_NONE).test(element.value.getLast())).isPresent();
    }

    private static boolean isUnsafeAuthorisationArgument(SubscriptionContext subscriptionContext, CdkUtils.ExpressionFlow expression) {
        return expression.getExpression(PublicApiIsSecuritySensitiveCheck.isCallExpression().and(CdkPredicate.isFqn("aws_cdk.aws_apigateway.MethodOptions"))).flatMap(expr -> CdkUtils.getArgument(subscriptionContext, (CallExpression)expr, AUTHORIZATION_TYPE)).filter(expr -> expr.hasExpression(CdkPredicate.isFqn(AUTHORIZATION_TYPE_NONE))).isPresent();
    }

    public static Predicate<Expression> isCallExpression() {
        return expression -> expression.is(Tree.Kind.CALL_EXPR);
    }
}

