/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

public class MultipleWhitespaceFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Replace spaces with quantifier `{%s}`.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public MultipleWhitespaceFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitSequence(SequenceTree sequence) {
        if (!sequence.activeFlags().contains(4)) {
            ArrayDeque<RegexTree> whitespaces = new ArrayDeque<RegexTree>();
            for (RegexTree item : sequence.getItems()) {
                if (MultipleWhitespaceFinder.isWhitespace(item)) {
                    whitespaces.add(item);
                    continue;
                }
                if (whitespaces.size() > 1) {
                    this.reportMultipleWhitespaces(sequence, whitespaces);
                    whitespaces.clear();
                    continue;
                }
                whitespaces.clear();
            }
            if (whitespaces.size() > 1) {
                this.reportMultipleWhitespaces(sequence, whitespaces);
            }
        }
        super.visitSequence(sequence);
    }

    private static boolean isWhitespace(RegexTree element) {
        return element.is(RegexTree.Kind.CHARACTER) && " ".equals(((CharacterTree)element).characterAsString());
    }

    private void reportMultipleWhitespaces(SequenceTree parentSequence, Deque<RegexTree> whitespaces) {
        whitespaces.removeFirst();
        this.regexElementIssueReporter.report(SubSequence.fromSequence(parentSequence, whitespaces), String.format(MESSAGE, whitespaces.size() + 1), null, Collections.emptyList());
    }

    static class SubSequence
    implements RegexSyntaxElement {
        private final RegexSource source;
        private final IndexRange range;

        private SubSequence(RegexSource source, IndexRange range) {
            this.source = source;
            this.range = range;
        }

        protected static SubSequence fromSequence(SequenceTree parentSequence, Deque<RegexTree> items) {
            IndexRange range = new IndexRange(items.getFirst().getRange().getBeginningOffset(), items.getLast().getRange().getEndingOffset());
            return new SubSequence(parentSequence.getSource(), range);
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexRange getRange() {
            return this.range;
        }

        @Override
        public RegexSource getSource() {
            return this.source;
        }
    }
}

