/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.maven.helpers;

import java.util.regex.Pattern;
import org.sonar.plugins.xml.checks.maven.helpers.StringMatcher;

public class PatternMatcher
implements StringMatcher {
    private final Pattern pattern;

    public PatternMatcher(String regex) {
        this.pattern = PatternMatcher.compileRegex(regex);
    }

    @Override
    public boolean test(String value) {
        return !value.isEmpty() && this.pattern.matcher(value).matches();
    }

    private static Pattern compileRegex(String regex) {
        try {
            return Pattern.compile(regex, 32);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Unable to compile the regular expression '" + regex + "', " + e.getMessage());
        }
    }
}

