// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zbc -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBC

#include <stdint.h>

// RV32ZBC-LABEL: @clmul_32(
// RV32ZBC-NEXT:  entry:
// RV32ZBC-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV32ZBC-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// RV32ZBC-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV32ZBC-NEXT:    store i32 [[B:%.*]], ptr [[B_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.clmul.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBC-NEXT:    ret i32 [[TMP2]]
//
uint32_t clmul_32(uint32_t a, uint32_t b) {
  return __builtin_riscv_clmul_32(a, b);
}

// RV32ZBC-LABEL: @clmulh_32(
// RV32ZBC-NEXT:  entry:
// RV32ZBC-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV32ZBC-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// RV32ZBC-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV32ZBC-NEXT:    store i32 [[B:%.*]], ptr [[B_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.clmulh.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBC-NEXT:    ret i32 [[TMP2]]
//
uint32_t clmulh_32(uint32_t a, uint32_t b) {
  return __builtin_riscv_clmulh_32(a, b);
}

// RV32ZBC-LABEL: @clmulr_32(
// RV32ZBC-NEXT:  entry:
// RV32ZBC-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV32ZBC-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// RV32ZBC-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV32ZBC-NEXT:    store i32 [[B:%.*]], ptr [[B_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B_ADDR]], align 4
// RV32ZBC-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.clmulr.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBC-NEXT:    ret i32 [[TMP2]]
//
uint32_t clmulr_32(uint32_t a, uint32_t b) {
  return __builtin_riscv_clmulr_32(a, b);
}
