"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.testPlugin = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@jest/core");
const jest_plugin_config_1 = require("../../../config/jest.plugin.config");
const useSpinner_1 = require("../../utils/useSpinner");
const testPlugin = ({ updateSnapshot, coverage, watch, testPathPattern, testNamePattern, maxWorkers, }) => (0, useSpinner_1.useSpinner)('Running tests', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const testConfig = (0, jest_plugin_config_1.loadJestPluginConfig)();
    const cliConfig = {
        config: JSON.stringify(testConfig),
        updateSnapshot,
        coverage,
        watch,
        testPathPattern: testPathPattern ? [testPathPattern] : [],
        testNamePattern: testNamePattern ? [testNamePattern] : [],
        passWithNoTests: true,
        maxWorkers,
    };
    // @ts-ignore
    const runJest = () => (0, core_1.runCLI)(cliConfig, [process.cwd()]);
    if (watch) {
        runJest();
    }
    else {
        // @ts-ignore
        const results = yield runJest();
        if (results.results.numFailedTests > 0 || results.results.numFailedTestSuites > 0) {
            throw new Error('Tests failed');
        }
    }
}));
exports.testPlugin = testPlugin;
//# sourceMappingURL=tests.js.map