/*
 * Rekor
 *
 * Rekor is a cryptographically secure, immutable transparency log for signed software releases.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use crate::rekor::TreeSize;
use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, PartialEq, Eq, Default, Serialize, Deserialize)]
pub struct InactiveShardLogInfo {
    /// The current hash value stored at the root of the merkle tree
    #[serde(rename = "rootHash")]
    pub root_hash: String,
    /// The current number of nodes in the merkle tree
    #[serde(rename = "treeSize")]
    pub tree_size: TreeSize,
    /// The current signed tree head
    #[serde(rename = "signedTreeHead")]
    pub signed_tree_head: String,
    /// The current treeID
    #[serde(rename = "treeID")]
    pub tree_id: String,
}

impl InactiveShardLogInfo {
    pub fn new(
        root_hash: String,
        tree_size: TreeSize,
        signed_tree_head: String,
        tree_id: String,
    ) -> InactiveShardLogInfo {
        InactiveShardLogInfo {
            root_hash,
            tree_size,
            signed_tree_head,
            tree_id,
        }
    }
}
