/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.wrapper.BootstrapMainStarter;
import org.apache.maven.wrapper.DefaultDownloader;
import org.apache.maven.wrapper.Installer;
import org.apache.maven.wrapper.Logger;
import org.apache.maven.wrapper.PathAssembler;
import org.apache.maven.wrapper.SystemPropertiesHandler;
import org.apache.maven.wrapper.WrapperExecutor;
import org.apache.maven.wrapper.cli.CommandLineParser;
import org.apache.maven.wrapper.cli.SystemPropertiesCommandLineConverter;

public class MavenWrapperMain {
    private static final String POM_PROPERTIES = "/META-INF/maven/org.apache.maven.wrapper/maven-wrapper/pom.properties";
    public static final String DEFAULT_MAVEN_USER_HOME = System.getProperty("user.home") + "/.m2";
    public static final String MAVEN_USER_HOME_PROPERTY_KEY = "maven.user.home";
    public static final String MAVEN_USER_HOME_ENV_KEY = "MAVEN_USER_HOME";
    public static final String MVNW_VERBOSE = "MVNW_VERBOSE";
    public static final String MVNW_USERNAME = "MVNW_USERNAME";
    public static final String MVNW_PASSWORD = "MVNW_PASSWORD";
    public static final String MVNW_REPOURL = "MVNW_REPOURL";

    public static void main(String[] args) throws Exception {
        File wrapperJar = MavenWrapperMain.wrapperJar();
        File propertiesFile = MavenWrapperMain.wrapperProperties(wrapperJar);
        File rootDir = MavenWrapperMain.rootDir(wrapperJar);
        String wrapperVersion = MavenWrapperMain.wrapperVersion();
        Logger.info("Apache Maven Wrapper " + wrapperVersion);
        Properties systemProperties = System.getProperties();
        systemProperties.putAll(MavenWrapperMain.parseSystemPropertiesFromArgs(args));
        MavenWrapperMain.addSystemProperties(rootDir);
        WrapperExecutor wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile(propertiesFile, System.out);
        wrapperExecutor.execute(args, new Installer(new DefaultDownloader("mvnw", wrapperVersion), new PathAssembler(MavenWrapperMain.mavenUserHome())), new BootstrapMainStarter());
    }

    private static Map<String, String> parseSystemPropertiesFromArgs(String[] args) {
        SystemPropertiesCommandLineConverter converter = new SystemPropertiesCommandLineConverter();
        CommandLineParser commandLineParser = new CommandLineParser();
        converter.configure(commandLineParser);
        commandLineParser.allowUnknownOptions();
        return (Map)converter.convert(commandLineParser.parse(args));
    }

    private static void addSystemProperties(File rootDir) {
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(MavenWrapperMain.mavenUserHome(), "maven.properties")));
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(rootDir, "maven.properties")));
    }

    private static File rootDir(File wrapperJar) {
        return wrapperJar.getParentFile().getParentFile().getParentFile();
    }

    private static File wrapperProperties(File wrapperJar) {
        return new File(wrapperJar.getParent(), wrapperJar.getName().replaceFirst("\\.jar$", ".properties"));
    }

    private static File wrapperJar() {
        URI location;
        try {
            location = MavenWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new RuntimeException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        return new File(location.getPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String wrapperVersion() {
        try (InputStream resourceAsStream = MavenWrapperMain.class.getResourceAsStream(POM_PROPERTIES);){
            if (resourceAsStream == null) {
                throw new IllegalStateException("/META-INF/maven/org.apache.maven.wrapper/maven-wrapper/pom.properties not found.");
            }
            Properties mavenProperties = new Properties();
            mavenProperties.load(resourceAsStream);
            String version = mavenProperties.getProperty("version");
            if (version == null) {
                throw new NullPointerException("No version specified in /META-INF/maven/org.apache.maven.wrapper/maven-wrapper/pom.properties");
            }
            String string = version;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine wrapper version.", e);
        }
    }

    private static File mavenUserHome() {
        String mavenUserHome = System.getProperty(MAVEN_USER_HOME_PROPERTY_KEY);
        if (mavenUserHome != null) {
            return new File(mavenUserHome);
        }
        mavenUserHome = System.getenv(MAVEN_USER_HOME_ENV_KEY);
        return new File(mavenUserHome == null ? DEFAULT_MAVEN_USER_HOME : mavenUserHome);
    }
}

