# *Percona XtraBackup* 2.4.25


* **Date**

    April 26, 2022


[Percona XtraBackup for MySQL Databases](https://www.percona.com/software/mysql-database/percona-xtrabackup) enables MySQL backups without blocking user queries. Percona XtraBackup is ideal for companies with large data sets and mission-critical applications that cannot tolerate long periods of downtime. Offered free as an open source solution, Percona XtraBackup drives down backup costs while providing unique features for MySQL backups.

Percona XtraBackup 2.4 does not support making backups of databases created in *MySQL 8.0*, *Percona Server for MySQL 8.0*, or *Percona XtraDB Cluster 8.0*. Use [Percona XtraBackup 8.0](https://www.percona.com/downloads/Percona-XtraBackup-LATEST/#) to make backups for these versions.

## Release Highlights

The xbcloud binary adds support for the [Microsoft Azure Cloud Storage](../../xbcloud/xbcloud_azure.md#xbcloud-azure) using the REST API.

## New Features

* [PXB-1883](https://jira.percona.com/browse/PXB-1883): Implements support for Microsoft Azure Cloud Storage in the xbcloud binary. (Thanks to Ivan Groenewold for reporting this issue)

## Bugs Fixed

* [PXB-2608](https://jira.percona.com/browse/PXB-2608): Upgraded the Vault API to V2 (Thanks to Benedito Marques Magalhaes for reporting this issue)

* [PXB-2649](https://jira.percona.com/browse/PXB-2649): Fix for compilation issues on GCC-10.

* [PXB-2648](https://jira.percona.com/browse/PXB-2648): CURL prior to 7.38.0 version doesn’t use CURLE_HTTP2 and throws an error `'CURLE_HTTP2' is not a member of 'CURLcode'`. Added CURLE_OBSOLETE16 as a connectivity error code. In CURL versions after 7.38.0, CURLE_OBSOLETE16 is translated to CURLE_HTTP2.

* [PXB-2711](https://jira.percona.com/browse/PXB-2711): Fix for libgcrypt initialization warnings in xtrabackup.

* [PXB-2722](https://jira.percona.com/browse/PXB-2722): Fix for when via command line, a password, passed using the -p option, was written into the backup tool_command in xtrabackup_info.

## Useful Links

* The [Percona XtraBackup installation instructions](https://www.percona.com/doc/percona-xtrabackup/2.4/installation.html)

* The [Percona XtraBackup downloads](https://www.percona.com/downloads/Percona-XtraBackup-2.4)

* The [Percona XtraBackup GitHub location](https://github.com/percona/percona-xtrabackup)

* To contribute to the documentation, review the [Documentation Contribution Guide](https://github.com/percona/percona-xtrabackup/blob/8.0/storage/innobase/xtrabackup/doc/source/contributing.md)
