/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispEngine;
import java.util.List;
import java.util.stream.Stream;

class ThreadAsWisp {
    private static final String JAVA_LANG_PKG = "package:java.lang";
    private static int nonDaemonCount;
    private static Thread preventShutdownThread;

    ThreadAsWisp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static boolean tryStart(Thread thread, Runnable runnable, long l) {
        if (WispEngine.isEngineThread(thread)) {
            return false;
        }
        if (WispConfiguration.ALL_THREAD_AS_WISP ? ThreadAsWisp.matchList(thread, runnable, WispConfiguration.getThreadAsWispBlacklist()) : !ThreadAsWisp.matchList(thread, runnable, WispConfiguration.getThreadAsWispWhitelist())) {
            return false;
        }
        if (!thread.isDaemon()) {
            Class<ThreadAsWisp> clazz = ThreadAsWisp.class;
            // MONITORENTER : com.alibaba.wisp.engine.ThreadAsWisp.class
            if (nonDaemonCount++ == 0) {
                assert (preventShutdownThread == null);
                preventShutdownThread = new PreventShutdownThread();
                preventShutdownThread.start();
            }
            // MONITOREXIT : clazz
        }
        WispEngine.JLA.setWispAlive(thread, true);
        WispEngine.current().startAsThread(thread, thread.getName(), thread, l);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void exit(Thread thread) {
        WispEngine.JLA.threadExit(thread);
        Object object = thread;
        synchronized (object) {
            thread.notifyAll();
        }
        if (thread.isDaemon()) return;
        object = ThreadAsWisp.class;
        synchronized (ThreadAsWisp.class) {
            if (--nonDaemonCount != 0) return;
            assert (preventShutdownThread != null && !preventShutdownThread.isInterrupted());
            preventShutdownThread.interrupt();
            preventShutdownThread = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static boolean matchList(Thread thread, Runnable runnable, List<String> list) {
        return Stream.concat(Stream.of(JAVA_LANG_PKG), list.stream()).anyMatch(string -> {
            Class<?> clazz = (runnable == null ? thread : runnable).getClass();
            String[] stringArray = string.split(":");
            if (stringArray.length != 2) {
                return false;
            }
            switch (stringArray[0]) {
                case "class": {
                    return stringArray[1].equals(clazz.getName());
                }
                case "package": {
                    Package package_ = clazz.getPackage();
                    String string2 = package_ == null ? "" : package_.getName();
                    return stringArray[1].equals(string2);
                }
                case "name": {
                    return ThreadAsWisp.wildCardMatch(thread.getName(), stringArray[1]);
                }
            }
            return false;
        });
    }

    private static boolean wildCardMatch(String string, String string2) {
        return string.matches(string2.replace("?", ".?").replace("*", ".*"));
    }

    private static class PreventShutdownThread
    extends Thread {
        private static int startCount;

        private PreventShutdownThread() {
            super(WispEngine.DAEMON_THREAD_GROUP, "Wisp-Prevent-Shutdown-" + startCount++);
            this.setDaemon(false);
        }

        @Override
        public synchronized void run() {
            try {
                while (true) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

