/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.WispScheduler;
import com.alibaba.wisp.engine.WispSysmon;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class WispConfiguration {
    private static final String DELIMITER = ";";
    static final boolean TRANSPARENT_WISP_SWITCH;
    static final boolean ENABLE_THREAD_AS_WISP;
    static final boolean ALL_THREAD_AS_WISP;
    static final int STACK_SIZE;
    static final boolean PARK_ONE_MS_AT_LEAST;
    static final int WORKER_COUNT;
    static final boolean ENABLE_HANDOFF;
    static final WispSysmon.Policy HANDOFF_POLICY;
    static final int SYSMON_TICK_US;
    static final int MIN_PARK_NANOS;
    static final int POLLER_SHARDING_SIZE;
    static final int SYSMON_CARRIER_GROW_TICK_US;
    static final boolean WISP_PROFILE;
    static final boolean WISP_PROFILE_LOG_ENABLED;
    static final int WISP_PROFILE_LOG_INTERVAL_MS;
    static final String WISP_PROFILE_LOG_PATH;
    static final boolean WISP_HIGH_PRECISION_TIMER;
    static final int WISP_ENGINE_TASK_CACHE_SIZE;
    static final int WISP_ENGINE_TASK_GLOBAL_CACHE_SIZE;
    static final int WISP_SCHEDULE_STEAL_RETRY;
    static final int WISP_SCHEDULE_PUSH_RETRY;
    static final int WISP_SCHEDULE_HELP_STEAL_RETRY;
    static final WispScheduler.SchedulingPolicy SCHEDULING_POLICY;
    static final boolean USE_DIRECT_SELECTOR_WAKEUP;
    static final boolean CARRIER_AS_POLLER;
    static final boolean MONOLITHIC_POLL;
    static final boolean CARRIER_GROW;
    static final boolean WISP_ENABLE_SOCKET_LOCK;
    static final int WISP_CONTROL_GROUP_CFS_PERIOD;
    private static List<String> THREAD_AS_WISP_BLACKLIST;
    private static List<String> THREAD_AS_WISP_WHITELIST;
    private static final int UNLOADED = 0;
    private static final int LOADING = 1;
    private static final int LOADED = 2;
    private static final AtomicInteger bizLoadStatus;

    WispConfiguration() {
    }

    private static void checkCompatibility() {
        WispConfiguration.checkDependency(ENABLE_THREAD_AS_WISP, "-Dcom.alibaba.wisp.enableThreadAsWisp=true", TRANSPARENT_WISP_SWITCH, "-Dcom.alibaba.wisp.transparentWispSwitch=true");
        WispConfiguration.checkDependency(ENABLE_HANDOFF, "-Dcom.alibaba.wisp.enableHandOff=true", TRANSPARENT_WISP_SWITCH, "-Dcom.alibaba.wisp.enableThreadAsWisp=true");
        WispConfiguration.checkDependency(ALL_THREAD_AS_WISP, "-Dcom.alibaba.wisp.allThreadAsWisp=true", ENABLE_THREAD_AS_WISP, "-Dcom.alibaba.wisp.enableThreadAsWisp=true");
        WispConfiguration.checkDependency(CARRIER_AS_POLLER, "-Dcom.alibaba.wisp.useCarrierAsPoller=true", ALL_THREAD_AS_WISP, "-Dcom.alibaba.wisp.allThreadAsWisp=true");
    }

    private static void checkDependency(boolean bl, String string, boolean bl2, String string2) {
        if (bl && !bl2) {
            throw new IllegalArgumentException("\"" + string + "\" depends on \"" + string2 + "\"");
        }
    }

    private static int parsePositiveIntegerParameter(Properties properties, String string, int n) {
        String string2;
        if (properties == null || (string2 = properties.getProperty(string)) == null) {
            return n;
        }
        int n2 = n;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2 <= 0 ? n : n2;
    }

    private static boolean parseBooleanParameter(Properties properties, String string, boolean bl) {
        String string2;
        if (properties == null || (string2 = properties.getProperty(string)) == null) {
            return bl;
        }
        return Boolean.parseBoolean(string2);
    }

    private static List<String> parseListParameter(Properties properties, Properties properties2, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            string2 = properties2.getProperty(string);
        }
        return string2 == null ? Collections.emptyList() : Arrays.asList(string2.trim().split(DELIMITER));
    }

    private static void loadBizConfig() {
        File file;
        Properties properties = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        String string = properties.getProperty("com.alibaba.wisp.config");
        Properties properties2 = new Properties();
        if (string != null && (file = new File(string)).exists()) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));){
                properties2.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        THREAD_AS_WISP_BLACKLIST = WispConfiguration.parseListParameter(properties, properties2, "com.alibaba.wisp.threadAsWisp.black");
        THREAD_AS_WISP_WHITELIST = WispConfiguration.parseListParameter(properties, properties2, "com.alibaba.wisp.threadAsWisp.white");
    }

    private static void ensureBizConfigLoaded() {
        if (bizLoadStatus.get() == 2) {
            return;
        }
        if (bizLoadStatus.get() == 0 && bizLoadStatus.compareAndSet(0, 1)) {
            try {
                WispConfiguration.loadBizConfig();
            }
            finally {
                bizLoadStatus.set(2);
            }
        }
        while (bizLoadStatus.get() != 2) {
        }
    }

    static List<String> getThreadAsWispBlacklist() {
        WispConfiguration.ensureBizConfigLoaded();
        assert (THREAD_AS_WISP_BLACKLIST != null);
        return THREAD_AS_WISP_BLACKLIST;
    }

    static List<String> getThreadAsWispWhitelist() {
        WispConfiguration.ensureBizConfigLoaded();
        assert (THREAD_AS_WISP_WHITELIST != null);
        return THREAD_AS_WISP_WHITELIST;
    }

    static {
        Properties properties = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        TRANSPARENT_WISP_SWITCH = properties.containsKey("com.alibaba.wisp.transparentWispSwitch") ? WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.transparentWispSwitch", false) : WispConfiguration.parseBooleanParameter(properties, "com.alibaba.transparentAsync", false);
        ENABLE_THREAD_AS_WISP = properties.containsKey("com.alibaba.wisp.enableThreadAsWisp") ? WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.enableThreadAsWisp", false) : WispConfiguration.parseBooleanParameter(properties, "com.alibaba.shiftThreadModel", false);
        ALL_THREAD_AS_WISP = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.allThreadAsWisp", false);
        STACK_SIZE = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.stacksize", 524288);
        PARK_ONE_MS_AT_LEAST = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.parkOneMs", true);
        WORKER_COUNT = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.carrierEngines", Runtime.getRuntime().availableProcessors());
        POLLER_SHARDING_SIZE = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.pollerShardingSize", 8);
        ENABLE_HANDOFF = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.enableHandOff", TRANSPARENT_WISP_SWITCH);
        HANDOFF_POLICY = WispSysmon.Policy.valueOf(properties.getProperty("com.alibaba.wisp.handoffPolicy", WispSysmon.Policy.PREEMPT.name()));
        SYSMON_TICK_US = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.sysmonTickUs", (int)TimeUnit.MILLISECONDS.toMicros(100L));
        MIN_PARK_NANOS = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.minParkNanos", 100);
        WISP_PROFILE_LOG_ENABLED = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.enableProfileLog", false);
        WISP_PROFILE_LOG_INTERVAL_MS = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.logTimeInternalMillis", 15000);
        if (WISP_PROFILE_LOG_ENABLED) {
            WISP_PROFILE = true;
            WISP_PROFILE_LOG_PATH = properties.getProperty("com.alibaba.wisp.logPath");
        } else {
            WISP_PROFILE = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.profile", false);
            WISP_PROFILE_LOG_PATH = "";
        }
        CARRIER_AS_POLLER = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.useCarrierAsPoller", ALL_THREAD_AS_WISP);
        MONOLITHIC_POLL = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.monolithicPoll", true);
        WISP_HIGH_PRECISION_TIMER = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.highPrecisionTimer", false);
        WISP_ENGINE_TASK_CACHE_SIZE = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.engineTaskCache", 20);
        WISP_ENGINE_TASK_GLOBAL_CACHE_SIZE = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.engineTaskGlobalCache", WORKER_COUNT * 10);
        WISP_SCHEDULE_STEAL_RETRY = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.schedule.stealRetry", Math.max(1, WORKER_COUNT / 2));
        WISP_SCHEDULE_PUSH_RETRY = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.schedule.pushRetry", WORKER_COUNT);
        WISP_SCHEDULE_HELP_STEAL_RETRY = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.schedule.helpStealRetry", Math.max(1, WORKER_COUNT / 4));
        SCHEDULING_POLICY = WispScheduler.SchedulingPolicy.valueOf(properties.getProperty("com.alibaba.wisp.schedule.policy", WORKER_COUNT > 16 ? WispScheduler.SchedulingPolicy.PUSH.name() : WispScheduler.SchedulingPolicy.PULL.name()));
        USE_DIRECT_SELECTOR_WAKEUP = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.directSelectorWakeup", true);
        WISP_ENABLE_SOCKET_LOCK = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.useSocketLock", true);
        CARRIER_GROW = WispConfiguration.parseBooleanParameter(properties, "com.alibaba.wisp.growCarrier", false);
        SYSMON_CARRIER_GROW_TICK_US = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.growCarrierTickUs", (int)TimeUnit.SECONDS.toMicros(5L));
        WISP_CONTROL_GROUP_CFS_PERIOD = WispConfiguration.parsePositiveIntegerParameter(properties, "com.alibaba.wisp.controlGroup.cfsPeriod", 0);
        WispConfiguration.checkCompatibility();
        bizLoadStatus = new AtomicInteger(0);
    }
}

