/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.management.WispCounterMXBean;
import com.alibaba.wisp.engine.WispCounter;
import com.alibaba.wisp.engine.WispEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.management.ObjectName;
import sun.management.Util;

public class WispCounterMXBeanImpl
implements WispCounterMXBean {
    private static final String WISP_COUNTER_MXBEAN_NAME = "com.alibaba.management:type=WispCounter";
    private static final Map<Long, WispCounter> managedEngineCounters = !WispEngine.transparentWispSwitch() ? new HashMap<Long, WispCounter>() : new ConcurrentHashMap<Long, WispCounter>(100);

    @Override
    public List<Boolean> getRunningStates() {
        return this.aggregate(WispCounter::getRunningState);
    }

    @Override
    public List<Long> getSwitchCount() {
        return this.aggregate(WispCounter::getSwitchCount);
    }

    @Override
    public List<Long> getWaitTimeTotal() {
        return this.aggregate(WispCounter::getWaitTimeTotal);
    }

    @Override
    public List<Long> getRunningTimeTotal() {
        return this.aggregate(WispCounter::getRunningTimeTotal);
    }

    @Override
    public List<Long> getCompleteTaskCount() {
        return this.aggregate(WispCounter::getCompletedTaskCount);
    }

    @Override
    public List<Long> getCreateTaskCount() {
        return this.aggregate(WispCounter::getCreateTaskCount);
    }

    @Override
    public List<Long> getParkCount() {
        return this.aggregate(WispCounter::getParkCount);
    }

    @Override
    public List<Long> getUnparkCount() {
        return this.aggregate(WispCounter::getUnparkCount);
    }

    @Override
    public List<Long> getLazyUnparkCount() {
        return this.aggregate(wispCounter -> 0L);
    }

    @Override
    public List<Long> getUnparkInterruptSelectorCount() {
        return this.aggregate(WispCounter::getUnparkInterruptSelectorCount);
    }

    @Override
    public List<Long> getSelectableIOCount() {
        return this.aggregate(WispCounter::getSelectableIOCount);
    }

    @Override
    public List<Long> getTimeOutCount() {
        return this.aggregate(WispCounter::getTimeOutCount);
    }

    @Override
    public List<Long> getEventLoopCount() {
        return this.aggregate(WispCounter::getEventLoopCount);
    }

    @Override
    public List<Long> getQueueLength() {
        return this.aggregate(WispCounter::getCurrentTaskQueueLength);
    }

    @Override
    public List<Long> getNumberOfRunningTasks() {
        return this.aggregate(WispCounter::getCurrentRunningTaskCount);
    }

    @Override
    public List<Long> getTotalEnqueueTime() {
        return this.aggregate(WispCounter::getTotalEnqueueTime);
    }

    @Override
    public List<Long> getEnqueueCount() {
        return this.aggregate(WispCounter::getEnqueueCount);
    }

    @Override
    public List<Long> getTotalExecutionTime() {
        return this.aggregate(WispCounter::getTotalExecutionTime);
    }

    @Override
    public List<Long> getExecutionCount() {
        return this.aggregate(WispCounter::getExecutionCount);
    }

    @Override
    public List<Long> getTotalWaitSocketIOTime() {
        return this.aggregate(WispCounter::getTotalWaitSocketIOTime);
    }

    @Override
    public List<Long> getWaitSocketIOCount() {
        return this.aggregate(WispCounter::getWaitSocketIOCount);
    }

    @Override
    public List<Long> getTotalBlockingTime() {
        return this.aggregate(WispCounter::getTotalBlockingTime);
    }

    @Override
    public WispCounter getWispCounter(long l) {
        return WispEngine.getWispCounter(l);
    }

    private <T> List<T> aggregate(Function<WispCounter, T> function) {
        ArrayList<T> arrayList = new ArrayList<T>(managedEngineCounters.size());
        for (Map.Entry<Long, WispCounter> entry : managedEngineCounters.entrySet()) {
            arrayList.add(function.apply(entry.getValue()));
        }
        return arrayList;
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName(WISP_COUNTER_MXBEAN_NAME);
    }

    static void register(WispCounter wispCounter) {
        managedEngineCounters.put(wispCounter.carrier.getId(), wispCounter);
    }

    static void deRegister(WispCounter wispCounter) {
        managedEngineCounters.remove(wispCounter.carrier.getId());
        wispCounter.cleanup();
    }
}

