/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.alibaba.rcm.internal.AbstractResourceContainer;
import com.alibaba.tenant.TenantContainer;
import com.alibaba.tenant.TenantGlobals;
import com.alibaba.wisp.engine.WispEngine;
import com.alibaba.wisp.engine.WispTask;
import java.dyn.CoroutineSupport;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.internal.misc.TerminatingThreadLocal;
import sun.misc.Contended;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.misc.WispEngineAccess;
import sun.nio.ch.Interruptible;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public class Thread
implements Runnable {
    private volatile String name;
    private int priority;
    private Thread threadQ;
    private long eetop;
    private boolean single_step;
    private boolean daemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    private long nativeParkEventPointer;
    private long tid;
    private static long threadSeqNumber;
    private volatile int threadStatus = 0;
    TenantContainer inheritedTenantContainer;
    AbstractResourceContainer resourceContainer;
    AbstractResourceContainer inheritedResourceContainer;
    volatile Object parkBlocker;
    private volatile Interruptible blocker;
    private final Object blockerLock = new Object();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private CoroutineSupport coroutineSupport;
    WispTask wispTask;
    volatile boolean wispIsAlive;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;
    private static final RuntimePermission SUBCLASS_IMPLEMENTATION_PERMISSION;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    @Contended(value="tlr")
    long threadLocalRandomSeed;
    @Contended(value="tlr")
    int threadLocalRandomProbe;
    @Contended(value="tlr")
    int threadLocalRandomSecondarySeed;
    private static WispEngineAccess WEA;

    private static native void registerNatives();

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockedOn(Interruptible interruptible) {
        Object object = this.blockerLock;
        synchronized (object) {
            this.blocker = interruptible;
        }
    }

    CoroutineSupport getCoroutineSupport() {
        if (this.coroutineSupport != null) {
            return this.coroutineSupport;
        }
        Thread thread = Thread.currentThread0();
        return thread == this ? null : thread.getCoroutineSupport();
    }

    private void initializeCoroutineSupport() {
        if (this.coroutineSupport == null) {
            this.coroutineSupport = new CoroutineSupport(this);
        }
    }

    private void destroyCoroutineSupport() {
        try {
            if (this.coroutineSupport != null) {
                if (WEA != null) {
                    WEA.destroy();
                }
                this.coroutineSupport.drain();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Thread currentThread() {
        if (WEA != null) {
            return WEA.getCurrentTask().getThreadWrapper();
        }
        return Thread.currentThread0();
    }

    static native Thread currentThread0();

    public static void yield() {
        if (WEA != null) {
            WEA.yield();
        } else {
            Thread.yield0();
        }
    }

    static native void yield0();

    public static void sleep(long l) throws InterruptedException {
        if (WEA != null) {
            if (Thread.interrupted()) {
                throw new InterruptedException("sleep interrupted");
            }
            WEA.sleep(l);
            if (Thread.interrupted()) {
                throw new InterruptedException("sleep interrupted");
            }
            return;
        }
        Thread.sleep0(l);
    }

    private static native void sleep0(long var0) throws InterruptedException;

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep(l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this.init(threadGroup, runnable, string, l, null, true);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l, AccessControlContext accessControlContext, boolean bl) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = string;
        Thread thread = Thread.currentThread();
        SecurityManager securityManager = System.getSecurityManager();
        if (threadGroup == null) {
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        }
        threadGroup.checkAccess();
        if (securityManager != null && Thread.isCCLOverridden(this.getClass())) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        threadGroup.addUnstarted();
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.priority = thread.getPriority();
        this.contextClassLoader = securityManager == null || Thread.isCCLOverridden(thread.getClass()) ? thread.getContextClassLoader() : thread.contextClassLoader;
        this.inheritedAccessControlContext = accessControlContext != null ? accessControlContext : AccessController.getContext();
        this.target = runnable;
        this.setPriority(this.priority);
        if (bl && thread.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
        }
        this.stackSize = l;
        this.tid = Thread.nextThreadID();
        this.resourceContainer = AbstractResourceContainer.root();
        this.inheritedResourceContainer = thread.resourceContainer;
        if (VM.isBooted() && TenantGlobals.isTenantEnabled()) {
            this.inheritedTenantContainer = TenantContainer.current();
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    Thread(Runnable runnable, AccessControlContext accessControlContext) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), 0L, accessControlContext, false);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String string) {
        this.init(null, null, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string, 0L);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this.init(threadGroup, runnable, string, l);
    }

    public synchronized void start() {
        if (this.threadStatus != 0) {
            throw new IllegalThreadStateException();
        }
        this.group.add(this);
        boolean bl = false;
        try {
            if (WEA == null || !WispEngine.enableThreadAsWisp() || !WEA.tryStartThreadAsWisp(this, this.target, this.stackSize)) {
                this.start0();
            }
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    this.group.threadStartFailed(this);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private native void start0();

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    void exit() {
        if (TerminatingThreadLocal.REGISTRY.isPresent()) {
            TerminatingThreadLocal.threadTerminated();
        }
        if (this.group != null) {
            this.group.threadTerminated(this);
            this.group = null;
        }
        this.target = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        this.inheritedAccessControlContext = null;
        this.blocker = null;
        this.uncaughtExceptionHandler = null;
        this.inheritedTenantContainer = null;
        this.resourceContainer = null;
        this.inheritedResourceContainer = null;
    }

    @Deprecated
    public final void stop() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.checkAccess();
            if (this != Thread.currentThread()) {
                securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
            }
        }
        if (this.threadStatus != 0) {
            this.resume();
        }
        this.stop0(new ThreadDeath());
    }

    @Deprecated
    public final synchronized void stop(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this != Thread.currentThread()) {
            this.checkAccess();
        }
        if (WEA != null && this.wispTask != null) {
            if (this != Thread.currentThread()) {
                Object object = this.blockerLock;
                synchronized (object) {
                    Interruptible interruptible = this.blocker;
                    if (interruptible != null) {
                        WEA.interrupt(this.wispTask);
                        interruptible.interrupt(this);
                        return;
                    }
                }
            }
            WEA.interrupt(this.wispTask);
            return;
        }
        Object object = this.blockerLock;
        synchronized (object) {
            Interruptible interruptible = this.blocker;
            if (interruptible != null) {
                this.interrupt0();
                interruptible.interrupt(this);
                return;
            }
        }
        this.interrupt0();
    }

    public static boolean interrupted() {
        WispTask wispTask;
        Thread thread = Thread.currentThread0();
        if (WEA != null && (wispTask = WEA.getCurrentTask()) != null) {
            return WEA.testInterruptedAndClear(wispTask, true);
        }
        return thread.isInterrupted(true);
    }

    public boolean isInterrupted() {
        if (WEA != null && this.wispTask != null) {
            return WEA.testInterruptedAndClear(this.wispTask, false);
        }
        return this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final boolean isAlive() {
        if (WEA != null && this.wispIsAlive) {
            return true;
        }
        return this.isAlive0();
    }

    private final native boolean isAlive0();

    @Deprecated
    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    @Deprecated
    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            if (n > threadGroup.getMaxPriority()) {
                n = threadGroup.getMaxPriority();
            }
            this.priority = n;
            this.setPriority0(this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final synchronized void setName(String string) {
        this.checkAccess();
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = string;
        if (this.threadStatus != 0) {
            this.setNativeName(string);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    @Deprecated
    public native int countStackFrames();

    public final synchronized void join(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (l == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long l4;
            while (this.isAlive() && (l4 = l - l3) > 0L) {
                this.wait(l4);
                l3 = System.currentTimeMillis() - l2;
            }
        }
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + threadGroup.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + ",]";
    }

    @CallerSensitive
    public ClassLoader getContextClassLoader() {
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader.checkClassLoaderPermission(this.contextClassLoader, Reflection.getCallerClass());
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    public static native boolean holdsLock(Object var0);

    public StackTraceElement[] getStackTrace() {
        boolean bl;
        Object object;
        if (WEA != null) {
            object = this.wispTask;
            if (object == null) {
                return new StackTraceElement[0];
            }
            if (!WEA.runningAsCoroutine(this)) {
                bl = this != Thread.currentThread();
            } else {
                boolean bl2 = WEA.getCurrentTask() == object;
                boolean bl3 = bl = !bl2;
                if (!WEA.isThreadTask((WispTask)object) && !bl2) {
                    return WEA.getStackTrace((WispTask)object);
                }
            }
        } else {
            boolean bl4 = bl = this != Thread.currentThread();
        }
        if (bl) {
            object = System.getSecurityManager();
            if (object != null) {
                ((SecurityManager)object).checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            }
            if (!this.isAlive()) {
                return EMPTY_STACK_TRACE;
            }
            StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(new Thread[]{this});
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray[0];
            if (stackTraceElementArray2 == null) {
                stackTraceElementArray2 = EMPTY_STACK_TRACE;
            }
            return stackTraceElementArray2;
        }
        return new Exception().getStackTrace();
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        Thread[] threadArray = Thread.getThreads();
        StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(threadArray);
        HashMap<Thread, StackTraceElement[]> hashMap = new HashMap<Thread, StackTraceElement[]>(threadArray.length);
        for (int i = 0; i < threadArray.length; ++i) {
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray[i];
            if (stackTraceElementArray2 == null) continue;
            hashMap.put(threadArray[i], stackTraceElementArray2);
        }
        return hashMap;
    }

    private static boolean isCCLOverridden(Class<?> clazz) {
        if (clazz == Thread.class) {
            return false;
        }
        Thread.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        WeakClassKey weakClassKey = new WeakClassKey(clazz, Caches.subclassAuditsQueue);
        Boolean bl = (Boolean)Caches.subclassAudits.get(weakClassKey);
        if (bl == null) {
            bl = Thread.auditSubclass(clazz);
            Caches.subclassAudits.putIfAbsent(weakClassKey, bl);
        }
        return bl;
    }

    private static boolean auditSubclass(final Class<?> clazz) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class clazz2 = clazz; clazz2 != Thread.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("getContextClassLoader", new Class[0]);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] classArray = new Class[]{ClassLoader.class};
                            clazz2.getDeclaredMethod("setContextClassLoader", classArray);
                            return Boolean.TRUE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    private static native Thread[] getThreads();

    public long getId() {
        return this.tid;
    }

    public State getState() {
        return VM.toThreadState(this.threadStatus);
    }

    native boolean isInSameNative();

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : this.group;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.checkAccess();
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    private void dispatchUncaughtException(Throwable throwable) {
        this.getUncaughtExceptionHandler().uncaughtException(this, throwable);
    }

    static void processQueue(ReferenceQueue<Class<?>> referenceQueue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> concurrentMap) {
        Reference<Class<?>> reference;
        while ((reference = referenceQueue.poll()) != null) {
            concurrentMap.remove(reference);
        }
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();

    private native void setNativeName(String var1);

    static void wispBooted() {
        if (!WispEngine.transparentWispSwitch()) {
            throw new AssertionError();
        }
        WEA = SharedSecrets.getWispEngineAccess();
    }

    static {
        Thread.registerNatives();
        EMPTY_STACK_TRACE = new StackTraceElement[0];
        SUBCLASS_IMPLEMENTATION_PERMISSION = new RuntimePermission("enableContextClassLoaderOverride");
    }

    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> clazz, ReferenceQueue<Class<?>> referenceQueue) {
            super(clazz, referenceQueue);
            this.hash = System.identityHashCode(clazz);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof WeakClassKey) {
                Object t = this.get();
                return t != null && t == ((WeakClassKey)object).get();
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    private static class Caches {
        static final ConcurrentMap<WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }
}

