/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ext;

import java.io.FileDescriptor;
import java.net.SocketException;
import java.net.SocketOption;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ExtendedSocketOptions {
    public static final short SOCK_STREAM = 1;
    public static final short SOCK_DGRAM = 2;
    private final Set<SocketOption<?>> options;
    private static volatile ExtendedSocketOptions instance;

    public final boolean isOptionSupported(SocketOption<?> socketOption) {
        return this.options().contains(socketOption);
    }

    public final Set<SocketOption<?>> options() {
        return this.options;
    }

    public static final Set<SocketOption<?>> options(short s) {
        return ExtendedSocketOptions.getInstance().options0(s);
    }

    private Set<SocketOption<?>> options0(short s) {
        Set<SocketOption<?>> set = null;
        switch (s) {
            case 2: {
                set = Collections.unmodifiableSet(this.options.stream().filter(socketOption -> !socketOption.name().startsWith("TCP_")).collect(Collectors.toSet()));
                break;
            }
            case 1: {
                set = Collections.unmodifiableSet(this.options.stream().filter(socketOption -> !socketOption.name().startsWith("UDP_")).collect(Collectors.toSet()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid socket option type");
            }
        }
        return set;
    }

    public abstract void setOption(FileDescriptor var1, SocketOption<?> var2, Object var3) throws SocketException;

    public abstract Object getOption(FileDescriptor var1, SocketOption<?> var2) throws SocketException;

    protected ExtendedSocketOptions(Set<SocketOption<?>> set) {
        this.options = set;
    }

    public static final ExtendedSocketOptions getInstance() {
        return instance;
    }

    public static final void register(ExtendedSocketOptions extendedSocketOptions) {
        if (instance != null) {
            throw new InternalError("Attempting to reregister extended options");
        }
        instance = extendedSocketOptions;
    }

    static {
        try {
            Class<?> clazz = Class.forName("jdk.net.ExtendedSocketOptions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            instance = new NoExtendedSocketOptions();
        }
    }

    static final class NoExtendedSocketOptions
    extends ExtendedSocketOptions {
        NoExtendedSocketOptions() {
            super(Collections.emptySet());
        }

        @Override
        public void setOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption, Object object) throws SocketException {
            throw new UnsupportedOperationException("no extended options: " + socketOption.name());
        }

        @Override
        public Object getOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption) throws SocketException {
            throw new UnsupportedOperationException("no extended options: " + socketOption.name());
        }
    }
}

