/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.SharedSecrets;
import sun.nio.ch.EPoll;
import sun.nio.ch.IOEventAccess;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;

final class EPollPort
extends Port {
    private static final int MAX_EPOLL_EVENTS = 512;
    private static final int ENOENT = 2;
    private final int epfd;
    private boolean closed;
    private final int[] sp;
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private final long address;
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);

    EPollPort(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
        this.epfd = EPoll.epollCreate();
        int[] nArray = new int[2];
        try {
            EPollPort.socketpair(nArray);
            EPoll.epollCtl(this.epfd, 1, nArray[0], Net.POLLIN);
        }
        catch (IOException iOException) {
            EPollPort.close0(this.epfd);
            throw iOException;
        }
        this.sp = nArray;
        this.address = EPoll.allocatePollArray(512);
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    EPollPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        EPollPort ePollPort = this;
        synchronized (ePollPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        EPoll.freePollArray(this.address);
        EPollPort.close0(this.sp[0]);
        EPollPort.close0(this.sp[1]);
        EPollPort.close0(this.epfd);
    }

    private void wakeup() {
        if (this.wakeupCount.incrementAndGet() == 1) {
            try {
                EPollPort.interrupt(this.sp[1]);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        EPollPort ePollPort = this;
        synchronized (ePollPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        if (n == 0) {
            this.implClose();
        } else {
            while (n-- > 0) {
                this.wakeup();
            }
        }
    }

    @Override
    void startPoll(int n, int n2) {
        int n3 = EPoll.epollCtl(this.epfd, 3, n, n2 | 0x40000000);
        if (n3 == 2) {
            n3 = EPoll.epollCtl(this.epfd, 1, n, n2 | 0x40000000);
        }
        if (n3 != 0) {
            throw new AssertionError();
        }
    }

    private static native void socketpair(int[] var0) throws IOException;

    private static native void interrupt(int var0) throws IOException;

    private static native void drain1(int var0) throws IOException;

    private static native void close0(int var0);

    static /* synthetic */ void access$900(EPollPort ePollPort) {
        ePollPort.implClose();
    }

    static {
        IOUtil.load();
        SharedSecrets.setIOEventAccess(new IOEventAccess(){

            @Override
            public int eventCtlAdd() {
                return 1;
            }

            @Override
            public int eventCtlDel() {
                return 2;
            }

            @Override
            public int eventCtlMod() {
                return 3;
            }

            @Override
            public int eventOneShot() {
                return 0x40000000;
            }

            @Override
            public int noEvent() {
                return EPoll.ENOENT;
            }

            @Override
            public long allocatePollArray(int n) {
                return EPoll.allocatePollArray(n);
            }

            @Override
            public void freePollArray(long l) {
                EPoll.freePollArray(l);
            }

            @Override
            public long getEvent(long l, int n) {
                return EPoll.getEvent(l, n);
            }

            @Override
            public int getDescriptor(long l) {
                return EPoll.getDescriptor(l);
            }

            @Override
            public int getEvents(long l) {
                return EPoll.getEvents(l);
            }

            @Override
            public int eventCreate() throws IOException {
                return EPoll.epollCreate();
            }

            @Override
            public int eventCtl(int n, int n2, int n3, int n4) {
                return EPoll.epollCtl(n, n2, n3, n4);
            }

            @Override
            public int eventWait(int n, long l, int n2, int n3) throws IOException {
                return EPoll.epollWait(n, l, n2, n3);
            }

            @Override
            public void socketpair(int[] nArray) throws IOException {
                EPollPort.socketpair(nArray);
            }

            @Override
            public void interrupt(int n) throws IOException {
                EPollPort.interrupt(n);
            }

            @Override
            public void drain(int n) throws IOException {
                EPollPort.drain1(n);
            }

            @Override
            public void close(int n) {
                EPollPort.close0(n);
            }
        });
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block10: while (true) {
                    int n = EPoll.epollWait(EPollPort.this.epfd, EPollPort.this.address, 512);
                    EPollPort.this.fdToChannelLock.readLock().lock();
                    try {
                        while (true) {
                            Object object;
                            if (n-- <= 0) continue block10;
                            long l = EPoll.getEvent(EPollPort.this.address, n);
                            int n2 = EPoll.getDescriptor(l);
                            if (n2 == EPollPort.this.sp[0]) {
                                if (EPollPort.this.wakeupCount.decrementAndGet() == 0) {
                                    EPollPort.drain1(EPollPort.this.sp[0]);
                                }
                                if (n <= 0) {
                                    object = EPollPort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                    return object;
                                }
                                EPollPort.this.queue.offer(EPollPort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                continue;
                            }
                            object = (Port.PollableChannel)EPollPort.this.fdToChannel.get(n2);
                            if (object == null) continue;
                            int n3 = EPoll.getEvents(l);
                            Event event = new Event((Port.PollableChannel)object, n3);
                            if (n <= 0) {
                                Event event2 = event;
                                return event2;
                            }
                            EPollPort.this.queue.offer(event);
                        }
                    }
                    finally {
                        EPollPort.this.fdToChannelLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                EPollPort.this.queue.offer(EPollPort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;

        Event(Port.PollableChannel pollableChannel, int n) {
            this.channel = pollableChannel;
            this.events = n;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }
    }
}

