/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Objects;
import sun.nio.ch.rdma.RdmaPollSelectorProvider;

public class RdmaSockets {
    private RdmaSockets() {
    }

    public static Socket openSocket(ProtocolFamily protocolFamily) throws IOException {
        Objects.requireNonNull("protocol family is null");
        return RdmaPollSelectorProvider.provider().openSocketChannel().socket();
    }

    public static ServerSocket openServerSocket(ProtocolFamily protocolFamily) throws IOException {
        Objects.requireNonNull("protocol family is null");
        return RdmaPollSelectorProvider.provider().openServerSocketChannel().socket();
    }

    public static SocketChannel openSocketChannel(ProtocolFamily protocolFamily) throws IOException {
        Objects.requireNonNull("protocol family is null");
        SelectorProvider selectorProvider = RdmaPollSelectorProvider.provider();
        return ((RdmaPollSelectorProvider)selectorProvider).openSocketChannel(protocolFamily);
    }

    public static ServerSocketChannel openServerSocketChannel(ProtocolFamily protocolFamily) throws IOException {
        Objects.requireNonNull("protocol family is null");
        SelectorProvider selectorProvider = RdmaPollSelectorProvider.provider();
        return ((RdmaPollSelectorProvider)selectorProvider).openServerSocketChannel(protocolFamily);
    }

    public static Selector openSelector() throws IOException {
        SelectorProvider selectorProvider = RdmaPollSelectorProvider.provider();
        return selectorProvider.openSelector();
    }
}

