import { shallow } from 'enzyme';
import React from 'react';

import { DashboardModel, PanelModel } from '../dashboard/state';

import { TestRuleResult, Props } from './TestRuleResult';

jest.mock('@grafana/runtime', () => {
  const original = jest.requireActual('@grafana/runtime');

  return {
    ...original,
    getBackendSrv: () => ({
      post: jest.fn(),
    }),
  };
});

const setup = (propOverrides?: object) => {
  const props: Props = {
    panel: new PanelModel({ id: 1 }),
    dashboard: new DashboardModel({ panels: [{ id: 1 }] }),
  };

  Object.assign(props, propOverrides);

  const wrapper = shallow(<TestRuleResult {...props} />);

  return { wrapper, instance: wrapper.instance() as TestRuleResult };
};

describe('Render', () => {
  it('should render component', () => {
    const { wrapper } = setup();

    expect(wrapper).toMatchSnapshot();
  });
});

describe('Life cycle', () => {
  describe('component did mount', () => {
    it('should call testRule', () => {
      const { instance } = setup();
      instance.testRule = jest.fn();
      instance.componentDidMount();

      expect(instance.testRule).toHaveBeenCalled();
    });
  });
});
