/*
 * Copyright (c) 1997, 2022 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.jaxb.runtime.v2.schemagen.xmlschema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;

import java.util.Objects;

/**
 */
@XmlRootElement(name = "environmentModel")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "environmentModelType", propOrder = {
        "container",
        "distribution"
})
public class JaxbEnvironmentModel {

    @XmlElement
    private JaxbContainer container;

    @XmlElement
    private JaxbDistribution distribution;

    public JaxbContainer getContainer() {
        return this.container;
    }

    public void setContainer(final JaxbContainer container) {
        this.container = container;
    }

    public JaxbDistribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(final JaxbDistribution distribution) {
        this.distribution = distribution;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        JaxbEnvironmentModel that = (JaxbEnvironmentModel) o;

        if (!Objects.equals(container, that.container)) return false;
        return !(!Objects.equals(distribution, that.distribution));

    }

    @Override
    public int hashCode() {
        int result =  (container != null ? container.hashCode() : 0);
        result = 31 * result + (distribution != null ? distribution.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "JaxbEnvironmentModel{" +
                "container=" + container +
                ", distribution=" + distribution +
                '}';
    }
}
