/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import org.mozilla.jss.crypto.KBKDFDKMLengthParam;
import org.mozilla.jss.crypto.KBKDFDataParameter;
import org.mozilla.jss.crypto.KBKDFIterationVariableParam;
import org.mozilla.jss.crypto.KBKDFOptionalCounterParam;
import org.mozilla.jss.crypto.KBKDFParameterSpec;

public class KBKDFCounterParams
extends KBKDFParameterSpec {
    @Override
    protected void validateParameters() throws IllegalArgumentException {
        if (this.prfKey == null) {
            String msg = "Required parameter KDF key was never set.";
            throw new IllegalArgumentException(msg);
        }
        if (this.prf != 545L && this.prf != 593L && this.prf != 609L && this.prf != 625L && this.prf != 4234L) {
            Object msg = "Expected Pseudo-Random Function to be SHA1-HMAC, ";
            msg = (String)msg + "SHA2-HMAC, or AES-CMAC, but got unknown PKCS#11 ";
            msg = (String)msg + "constant: " + this.prf;
            throw new IllegalArgumentException((String)msg);
        }
        if (this.params == null || this.params.length == 0) {
            Object msg = "Expected non-null, non-zero length array of KDF ";
            msg = (String)msg + "parameters.";
            throw new IllegalArgumentException((String)msg);
        }
        int index = 0;
        for (KBKDFDataParameter param : this.params) {
            if (param instanceof KBKDFOptionalCounterParam) {
                String msg = "Got unexpected data parameter at index " + index;
                msg = msg + ": KBKDF Optional Counter Parameter is forbidden from ";
                msg = msg + "use with Counter mode KBKDF.";
                throw new IllegalArgumentException(msg);
            }
            if (param instanceof KBKDFIterationVariableParam) {
                KBKDFIterationVariableParam kivp = (KBKDFIterationVariableParam)param;
                if (kivp.widthInBits == -1L) {
                    Object msg = "Got unexpected data in KBKDF Iteration ";
                    msg = (String)msg + "Variable Parameter at index " + index + ": ";
                    msg = (String)msg + "Expected valid counter specification, but got ";
                    msg = (String)msg + "widthInBits of -1. Call setCounterSpec(...) ";
                    msg = (String)msg + "before using this parameter.";
                    throw new IllegalArgumentException((String)msg);
                }
            }
            if (param instanceof KBKDFDKMLengthParam) {
                KBKDFDKMLengthParam kdlp = (KBKDFDKMLengthParam)param;
                if (kdlp.widthInBits == 0L) {
                    Object msg = "Got unexpected data in KBKDF DKM Length ";
                    msg = (String)msg + "Parameter at index " + index + ": Expected valid ";
                    msg = (String)msg + "length specification, but got widthInBits of 0. ";
                    msg = (String)msg + "Call setLngthSpec(...) before using this ";
                    msg = (String)msg + "parameter.";
                    throw new IllegalArgumentException((String)msg);
                }
            }
            ++index;
        }
    }

    @Override
    protected native void acquireNativeResourcesInternal() throws Exception;

    @Override
    protected native void releaseNativeResourcesInternal() throws Exception;
}

