/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceUnCert4Crl
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceUnCert4Crl.class);

    public ServiceUnCert4Crl(CAService service) {
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        BigInteger[] oldSerialNo = request.getExtDataInBigIntegerArray("OLD_SERIALS");
        if (oldSerialNo == null || oldSerialNo.length < 1) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_UNREVOKE_MISSING_SERIAL", (Object[])new Object[0]));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_SERIAL_NUMBER", (String[])new String[0]));
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        String[] svcerrors = null;
        for (int i = 0; i < oldSerialNo.length; ++i) {
            try {
                cr.deleteCertificateRecord(oldSerialNo[i]);
                for (CRLIssuingPoint ip : engine.getCRLIssuingPoints()) {
                    if (ip == null) continue;
                    ip.addUnrevokedCert(oldSerialNo[i]);
                }
                continue;
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_DELETE_CERT_ERROR", (Object[])new Object[]{oldSerialNo[i].toString(), e.toString()}), (Throwable)e);
                if (svcerrors == null) {
                    svcerrors = new String[oldSerialNo.length];
                }
                svcerrors[i] = e.toString();
            }
        }
        if (svcerrors != null) {
            request.setExtData("serviceErrors", svcerrors);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_UNCERT4CRL_FAILED", (String[])new String[0]));
        }
        return true;
    }
}

