/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningAlgDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(SigningAlgDefault.class);
    public static final String CONFIG_ALGORITHM = "signingAlg";
    public static final String VAL_ALGORITHM = "signingAlg";
    public static final String DEF_CONFIG_ALGORITHMS = "-,SHA1withRSA,SHA256withRSA,SHA384withRSA,SHA512withRSA";

    public SigningAlgDefault() {
        this.addConfigName("signingAlg");
        this.addValueName("signingAlg");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("signingAlg")) {
            return new Descriptor("choice", DEF_CONFIG_ALGORITHMS, "SHA256withRSA", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SIGNING_ALGORITHM", (String[])new String[0]));
        }
        return null;
    }

    public String getSigningAlg() {
        CAEngine engine = CAEngine.getInstance();
        String signingAlg = this.getConfig("signingAlg");
        if (signingAlg == null || signingAlg.equals("") || signingAlg.equals("-")) {
            CertificateAuthority ca = engine.getCA();
            return ca.getDefaultAlgorithm();
        }
        return signingAlg;
    }

    public String getDefSigningAlgorithms() {
        StringBuffer allowed = new StringBuffer();
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        String[] algos = ca.getCASigningAlgorithms();
        for (int i = 0; i < algos.length; ++i) {
            if (allowed.length() == 0) {
                allowed.append(algos[i]);
                continue;
            }
            allowed.append(",");
            allowed.append(algos[i]);
        }
        return allowed.toString();
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("signingAlg")) {
            String allowed = this.getDefSigningAlgorithms();
            return new Descriptor("choice", allowed, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SIGNING_ALGORITHM", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals("signingAlg")) {
            try {
                info.set("algorithmID", (Object)new CertificateAlgorithmId(AlgorithmId.get((String)value)));
            }
            catch (Exception e) {
                logger.error("SigningAlgDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException("Invalid name " + name);
        }
        if (name.equals("signingAlg")) {
            CertificateAlgorithmId algId = null;
            try {
                algId = (CertificateAlgorithmId)info.get("algorithmID");
                AlgorithmId id = (AlgorithmId)algId.get("algorithm");
                return id.toString();
            }
            catch (Exception e) {
                logger.warn("SigningAlgDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SIGNING_ALGORITHM", (String[])new String[]{this.getSigningAlg()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        try {
            info.set("algorithmID", (Object)new CertificateAlgorithmId(AlgorithmId.get((String)this.getSigningAlg())));
        }
        catch (Exception e) {
            logger.warn("SigningAlgDefault: populate " + e.getMessage(), (Throwable)e);
        }
    }
}

