/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.PolicyConstraint;
import com.netscape.certsrv.profile.PolicyConstraintValue;
import com.netscape.certsrv.profile.PolicyDefault;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileData;
import com.netscape.certsrv.profile.ProfileDataInfo;
import com.netscape.certsrv.profile.ProfileDataInfos;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.certsrv.profile.ProfileNotFoundException;
import com.netscape.certsrv.profile.ProfileOutput;
import com.netscape.certsrv.profile.ProfileParameter;
import com.netscape.certsrv.profile.ProfileResource;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.cms.profile.common.CAEnrollProfile;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileConfig;
import com.netscape.cms.profile.common.ProfileInputConfig;
import com.netscape.cms.profile.common.ProfileInputsConfig;
import com.netscape.cms.profile.common.ProfileOutputConfig;
import com.netscape.cms.profile.common.ProfileOutputsConfig;
import com.netscape.cms.profile.common.ProfilePoliciesConfig;
import com.netscape.cms.profile.common.ProfilePolicy;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cms.servlet.profile.PolicyConstraintFactory;
import com.netscape.cms.servlet.profile.PolicyDefaultFactory;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.SimpleProperties;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileService
extends SubsystemService
implements ProfileResource {
    public static Logger logger = LoggerFactory.getLogger(ProfileService.class);
    private CAEngineConfig engineConfig;
    private PluginRegistry registry;
    private ProfileSubsystem ps;

    public ProfileService() {
        CAEngine engine = CAEngine.getInstance();
        this.engineConfig = engine.getConfig();
        this.registry = engine.getPluginRegistry();
        this.ps = engine.getProfileSubsystem();
    }

    public Response listProfiles(Integer start, Integer size) {
        Enumeration<String> e;
        GenericPrincipal genPrincipal;
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        ProfileDataInfos infos = new ProfileDataInfos();
        boolean visibleOnly = true;
        if (this.ps == null) {
            logger.error("listProfiles: ps is null");
            throw new PKIException("Error listing profiles.  Profile Service not available");
        }
        Principal principal = this.servletRequest.getUserPrincipal();
        if (principal != null && principal instanceof GenericPrincipal && ((genPrincipal = (GenericPrincipal)principal).hasRole("Certificate Manager Agents") || genPrincipal.hasRole("Certificate Manager Administrators"))) {
            visibleOnly = false;
        }
        if ((e = this.ps.getProfileIds()) == null) {
            return this.createOKResponse(infos);
        }
        ArrayList<ProfileDataInfo> results = new ArrayList<ProfileDataInfo>();
        while (e.hasMoreElements()) {
            try {
                String id = e.nextElement();
                ProfileDataInfo info = ProfileService.createProfileDataInfo(id, visibleOnly, this.uriInfo, this.getLocale(this.headers));
                if (info == null) continue;
                results.add(info);
            }
            catch (EBaseException ex) {}
        }
        int total = results.size();
        infos.setTotal(total);
        for (int i = start.intValue(); i < start + size && i < total; ++i) {
            infos.addEntry((Object)((ProfileDataInfo)results.get(i)));
        }
        return this.createOKResponse(infos);
    }

    private Profile getProfile(String profileId) throws ProfileNotFoundException {
        Profile profile;
        GenericPrincipal genPrincipal;
        boolean visibleOnly = true;
        if (profileId == null) {
            logger.error("retrieveProfile: profileID is null");
            throw new BadRequestException("Unable to retrieve profile: invalid profile ID");
        }
        if (this.ps == null) {
            logger.error("retrieveProfile: ps is null");
            throw new PKIException("Error retrieving profile.  Profile Service not available");
        }
        Principal principal = this.servletRequest.getUserPrincipal();
        if (principal != null && principal instanceof GenericPrincipal && ((genPrincipal = (GenericPrincipal)principal).hasRole("Certificate Manager Agents") || genPrincipal.hasRole("Certificate Manager Administrators"))) {
            visibleOnly = false;
        }
        try {
            profile = this.ps.getProfile(profileId);
        }
        catch (EProfileException e) {
            throw new ProfileNotFoundException(profileId, "Profile not found", (Throwable)e);
        }
        if (profile == null) {
            throw new ProfileNotFoundException(profileId);
        }
        if (visibleOnly && !profile.isVisible()) {
            throw new ProfileNotFoundException(profileId);
        }
        return profile;
    }

    public Response retrieveProfile(String profileId) throws ProfileNotFoundException {
        ProfileData data = null;
        try {
            data = this.createProfileData(profileId);
        }
        catch (EBaseException e) {
            e.printStackTrace();
            throw new ProfileNotFoundException(profileId);
        }
        return this.createOKResponse(data);
    }

    public Response retrieveProfileRaw(String profileId) throws Exception {
        Profile profile = this.getProfile(profileId);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        profile.getConfigStore().put("profileId", profileId);
        profile.getConfigStore().put("classId", this.ps.getProfileClassId(profileId));
        profile.getConfigStore().store(data);
        return this.createOKResponse(data.toByteArray());
    }

    public ProfileData createProfileData(String profileId) throws EBaseException {
        Enumeration<String> policySetIds;
        Enumeration<String> outputIds;
        Profile profile = this.getProfile(profileId);
        ProfileData data = new ProfileData();
        data.setAuthenticatorId(profile.getAuthenticatorId());
        data.setAuthzAcl(profile.getAuthzAcl());
        data.setClassId(this.ps.getProfileClassId(profileId));
        data.setDescription(profile.getDescription(this.getLocale(this.headers)));
        data.setEnabled(this.ps.isProfileEnable(profileId));
        data.setEnabledBy(this.ps.getProfileEnableBy(profileId));
        data.setId(profileId);
        data.setName(profile.getName(this.getLocale(this.headers)));
        data.setRenewal(Boolean.getBoolean(profile.isRenewal()));
        data.setVisible(profile.isVisible());
        data.setXMLOutput(Boolean.getBoolean(profile.isXmlOutput()));
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                ProfileInput input = ProfileService.createProfileInput(profile, inputIds.nextElement(), this.getLocale(this.headers));
                if (input == null) continue;
                data.addProfileInput(input);
            }
        }
        if ((outputIds = profile.getProfileOutputIds()) != null) {
            while (outputIds.hasMoreElements()) {
                ProfileOutput output = ProfileService.createProfileOutput(profile, outputIds.nextElement(), this.getLocale(this.headers));
                if (output == null) continue;
                data.addProfileOutput(output);
            }
        }
        if ((policySetIds = profile.getProfilePolicySetIds()) != null) {
            while (policySetIds.hasMoreElements()) {
                Vector<com.netscape.certsrv.profile.ProfilePolicy> pset = new Vector<com.netscape.certsrv.profile.ProfilePolicy>();
                String policySetId = policySetIds.nextElement();
                Enumeration<String> policyIds = profile.getProfilePolicyIds(policySetId);
                while (policyIds.hasMoreElements()) {
                    String policyId = policyIds.nextElement();
                    pset.add(this.createProfilePolicy(profile, policySetId, policyId));
                }
                if (pset.isEmpty()) continue;
                data.addProfilePolicySet(policySetId, pset);
            }
        }
        return data;
    }

    public com.netscape.certsrv.profile.ProfilePolicy createProfilePolicy(Profile profile, String setId, String policyId) throws EBaseException {
        ProfilePolicy policy = profile.getProfilePolicy(setId, policyId);
        ProfilePoliciesConfig policiesConfig = profile.getConfigStore().getPoliciesConfig();
        ConfigStore policyStore = policiesConfig.getSubStore(setId + "." + policy.getId(), ConfigStore.class);
        com.netscape.certsrv.profile.ProfilePolicy p = new com.netscape.certsrv.profile.ProfilePolicy();
        String constraintClassId = policyStore.getString("constraint.class_id");
        p.setConstraint(PolicyConstraintFactory.create(this.getLocale(this.headers), policy.getConstraint(), constraintClassId));
        String defaultClassId = policyStore.getString("default.class_id");
        p.setDef(PolicyDefaultFactory.create(this.getLocale(this.headers), policy.getDefault(), defaultClassId));
        p.setId(policy.getId());
        return p;
    }

    public static ProfileInput createProfileInput(Profile profile, String inputId, Locale locale) throws EBaseException {
        com.netscape.cms.profile.common.ProfileInput profileInput = profile.getProfileInput(inputId);
        if (profileInput == null) {
            return null;
        }
        ProfileConfig profileConfig = profile.getConfigStore();
        ProfileInputsConfig inputStore = profileConfig.getProfileInputsConfig();
        String name = profileInput.getName(locale);
        ProfileInputConfig inputConfig = inputStore.getProfileInputConfig(inputId);
        String classId = inputConfig.getString("class_id");
        ProfileInput input = new ProfileInput(inputId, name, classId);
        Enumeration<String> attrNames = profileInput.getValueNames();
        while (attrNames.hasMoreElements()) {
            String attrName = attrNames.nextElement();
            Descriptor descriptor = (Descriptor)profileInput.getValueDescriptor(locale, attrName);
            ProfileAttribute attr = new ProfileAttribute(attrName, null, descriptor);
            input.addAttribute(attr);
        }
        return input;
    }

    public static ProfileOutput createProfileOutput(Profile profile, String outputId, Locale locale) throws EBaseException {
        com.netscape.cms.profile.common.ProfileOutput profileOutput = profile.getProfileOutput(outputId);
        if (profileOutput == null) {
            return null;
        }
        ProfileConfig profileConfig = profile.getConfigStore();
        ProfileOutputsConfig outputStore = profileConfig.getProfileOutputsConfig();
        String name = profileOutput.getName(locale);
        ProfileOutputConfig outputConfig = outputStore.getProfileOutputConfig(outputId);
        String classId = outputConfig.getString("class_id");
        ProfileOutput output = new ProfileOutput(outputId, name, classId);
        Enumeration<String> attrNames = profileOutput.getValueNames();
        while (attrNames.hasMoreElements()) {
            String attrName = attrNames.nextElement();
            Descriptor descriptor = (Descriptor)profileOutput.getValueDescriptor(locale, attrName);
            ProfileAttribute attr = new ProfileAttribute(attrName, null, descriptor);
            output.addAttribute(attr);
        }
        return output;
    }

    public static ProfileDataInfo createProfileDataInfo(String profileId, boolean visibleOnly, UriInfo uriInfo, Locale locale) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        ProfileSubsystem ps = engine.getProfileSubsystem();
        if (profileId == null) {
            throw new EBaseException("Error creating ProfileDataInfo.");
        }
        ProfileDataInfo ret = null;
        Profile profile = null;
        profile = ps.getProfile(profileId);
        if (profile == null) {
            return null;
        }
        if (visibleOnly && !profile.isVisible()) {
            return null;
        }
        ret = new ProfileDataInfo();
        ret.setProfileId(profileId);
        ret.setProfileName(profile.getName(locale));
        ret.setProfileDescription(profile.getDescription(locale));
        UriBuilder profileBuilder = uriInfo.getBaseUriBuilder();
        URI uri = profileBuilder.path(ProfileResource.class).path("{id}").build(new Object[]{profileId});
        ret.setProfileURL(uri.toString());
        return ret;
    }

    public Response modifyProfileState(String profileId, String action) throws Exception {
        if (profileId == null) {
            logger.error("modifyProfileState: invalid request. profileId is null");
            throw new BadRequestException("Unable to modify profile state: Invalid Profile Id");
        }
        if (action == null) {
            logger.error("modifyProfileState: invalid request. action is null");
            throw new BadRequestException("Unable to modify profile state: Missing action");
        }
        if (this.ps == null) {
            logger.error("modifyProfileState: ps is null");
            throw new PKIException("Error modifying profile state.  Profile Service not available");
        }
        try {
            Profile profile = this.ps.getProfile(profileId);
            if (profile == null) {
                logger.error("Trying to modify profile: " + profileId + ".  Profile not found.");
                throw new ProfileNotFoundException(profileId);
            }
        }
        catch (EProfileException e1) {
            e1.printStackTrace();
            throw new PKIException("Error modifying profile state: unable to get profile");
        }
        Principal principal = this.servletRequest.getUserPrincipal();
        switch (action) {
            case "enable": {
                if (this.ps.isProfileEnable(profileId)) {
                    throw new ConflictingOperationException("Profile already enabled");
                }
                try {
                    this.ps.enableProfile(profileId, principal.getName());
                    this.ps.commitProfile(profileId);
                    this.auditProfileChangeState(profileId, "approve", "Success");
                    break;
                }
                catch (EProfileException e) {
                    logger.error("modifyProfileState: error enabling profile: " + e.getMessage(), (Throwable)e);
                    this.auditProfileChangeState(profileId, "approve", "Failure");
                    throw new PKIException("Error enabling profile");
                }
            }
            case "disable": {
                if (!this.ps.isProfileEnable(profileId)) {
                    throw new ConflictingOperationException("Profile already disabled");
                }
                String userid = principal.getName();
                try {
                    if (this.ps.checkOwner()) {
                        if (this.ps.getProfileEnableBy(profileId).equals(userid)) {
                            this.ps.disableProfile(profileId);
                            this.ps.commitProfile(profileId);
                            this.auditProfileChangeState(profileId, "disapprove", "Success");
                            break;
                        }
                        this.auditProfileChangeState(profileId, "disapprove", "Failure");
                        throw new UnauthorizedException("Profile can only be disabled by the agent that enabled it");
                    }
                    this.ps.disableProfile(profileId);
                    this.ps.commitProfile(profileId);
                    this.auditProfileChangeState(profileId, "disapprove", "Success");
                    break;
                }
                catch (EProfileException e) {
                    logger.error("modifyProfileState: Error disabling profile: " + e.getMessage(), (Throwable)e);
                    this.auditProfileChangeState(profileId, "disapprove", "Failure");
                    throw new PKIException("Error disabling profile");
                }
            }
            default: {
                this.auditProfileChangeState(profileId, "invalid", "Failure");
                throw new BadRequestException("Invalid operation");
            }
        }
        return this.createNoContentResponse();
    }

    public Response createProfile(String createProfileRequest) throws Exception {
        logger.info("ProfileService: Creating certificate profile");
        ProfileData data = (ProfileData)this.unmarshall(createProfileRequest, ProfileData.class);
        if (data == null) {
            logger.error("createProfile: profile data is null");
            throw new BadRequestException("Unable to create profile: Invalid profile data.");
        }
        if (this.ps == null) {
            logger.error("createProfile: ps is null");
            throw new PKIException("Error creating profile.  Profile Service not available");
        }
        Profile profile = null;
        String profileId = data.getId();
        LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
        try {
            profile = this.ps.getProfile(profileId);
            if (profile != null) {
                throw new ConflictingOperationException("Profile already exists");
            }
            auditParams.put("class_id", data.getClassId());
            auditParams.put("name", data.getName());
            auditParams.put("description", data.getDescription());
            auditParams.put("visible", Boolean.toString(data.isVisible()));
            PluginInfo info = this.registry.getPluginInfo("profile", data.getClassId());
            profile = this.ps.createProfile(profileId, data.getClassId(), info.getClassName());
            profile.setName(this.getLocale(this.headers), data.getName());
            profile.setDescription(this.getLocale(this.headers), data.getDescription());
            profile.setVisible(data.isVisible());
            this.ps.commitProfile(profileId);
            if (profile instanceof CAEnrollProfile) {
                ((CAEnrollProfile)profile).populate();
            }
            this.auditProfileChange("rules", "OP_ADD", profileId, "Success", auditParams);
            this.changeProfileData(data, profile);
            ProfileData profileData = this.createProfileData(profileId);
            URI uri = this.uriInfo.getBaseUriBuilder().path(ProfileResource.class).path("{id}").build(new Object[]{profileId});
            return this.createCreatedResponse(profileData, uri);
        }
        catch (EBaseException e) {
            logger.error("createProfile: error creating profile: " + e.getMessage(), (Throwable)e);
            this.auditProfileChange("rules", "OP_ADD", profileId, "Failure", auditParams);
            throw new PKIException("Error in creating profile", (Throwable)e);
        }
    }

    public Response createProfileRaw(byte[] data) {
        String classId;
        String profileId;
        if (data == null) {
            String message = "Unable to create profile: Missing profile data";
            logger.error(message);
            throw new BadRequestException(message);
        }
        if (this.ps == null) {
            String message = "Unable to create profile: Profile service not available";
            logger.error(message);
            throw new PKIException(message);
        }
        logger.info("ProfileService: Creating profile from raw data");
        LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
        SimpleProperties properties = new SimpleProperties();
        try {
            properties.load((InputStream)new ByteArrayInputStream(data));
            profileId = (String)properties.remove((Object)"profileId");
            classId = (String)properties.remove((Object)"classId");
        }
        catch (IOException e) {
            String message = "Unable to create profile: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new BadRequestException(message, (Throwable)e);
        }
        if (profileId == null) {
            String message = "Unable to create profile: Missing profile ID";
            logger.error(message);
            throw new BadRequestException(message);
        }
        if (classId == null) {
            String message = "Unable to create profile: Missing class ID";
            logger.error(message);
            throw new BadRequestException(message);
        }
        try {
            Profile tempProfile;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            properties.store((OutputStream)out, null);
            data = out.toByteArray();
            Profile profile = this.ps.getProfile(profileId);
            if (profile != null) {
                String message = "Unable to create profile: Profile already exists";
                logger.error(message);
                throw new ConflictingOperationException(message);
            }
            auditParams.put("class_id", classId);
            PluginInfo info = this.registry.getPluginInfo("profile", classId);
            String className = info.getClassName();
            try {
                tempProfile = (Profile)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                String message = "Unable to create profile: " + e.getMessage();
                logger.error(message, (Throwable)e);
                throw new PKIException(message, (Throwable)e);
            }
            tempProfile.setId(profileId);
            try {
                ProfileConfig profileConfig = new ProfileConfig();
                profileConfig.load(new ByteArrayInputStream(data));
                tempProfile.init(this.engineConfig, this.registry, profileConfig);
            }
            catch (Exception e) {
                String message = "Unable to create profile: " + e.getMessage();
                logger.error(message, (Throwable)e);
                throw new BadRequestException(message, (Throwable)e);
            }
            profile = this.ps.createProfile(profileId, classId, className);
            profile.getConfigStore().load(new ByteArrayInputStream(data));
            this.ps.disableProfile(profileId);
            this.ps.commitProfile(profileId);
            this.auditProfileChange("rules", "OP_ADD", profileId, "Success", auditParams);
            return this.createCreatedResponse(data, this.uriInfo.getAbsolutePath());
        }
        catch (EBaseException | IOException e) {
            String message = "Unable to create profile: " + e.getMessage();
            logger.error(message, e);
            this.auditProfileChange("rules", "OP_ADD", profileId, "Failure", auditParams);
            throw new PKIException(message, e);
        }
    }

    public Response modifyProfile(String profileId, String modifyProfileRequest) throws Exception {
        logger.info("ProfileService: Modifying certificate profile");
        ProfileData data = (ProfileData)this.unmarshall(modifyProfileRequest, ProfileData.class);
        if (profileId == null) {
            logger.error("modifyProfile: invalid request. profileId is null");
            throw new BadRequestException("Unable to modify profile: Invalid Profile Id");
        }
        if (data == null) {
            logger.error("modifyProfile: invalid request. data is null");
            throw new BadRequestException("Unable to modify profile: Invalid profile data");
        }
        if (this.ps == null) {
            logger.error("modifyProfile: ps is null");
            throw new PKIException("Error modifying profile.  Profile Service not available");
        }
        Profile profile = null;
        try {
            profile = this.ps.getProfile(profileId);
            if (profile == null) {
                throw new ProfileNotFoundException(profileId);
            }
            this.changeProfileData(data, profile);
            ProfileData profileData = this.createProfileData(profileId);
            return this.createOKResponse(profileData);
        }
        catch (EBaseException e) {
            logger.error("modifyProfile: error obtaining profile `" + profileId + "`: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Error modifying profile.  Cannot obtain profile.");
        }
    }

    public Response modifyProfileRaw(String profileId, byte[] data) throws Exception {
        if (profileId == null) {
            logger.error("modifyProfile: invalid request. profileId is null");
            throw new BadRequestException("Unable to modify profile: Invalid Profile Id");
        }
        if (data == null) {
            logger.error("modifyProfile: invalid request. data is null");
            throw new BadRequestException("Unable to modify profile: Invalid profile data");
        }
        if (this.ps == null) {
            logger.error("modifyProfile: ps is null");
            throw new PKIException("Error modifying profile.  Profile Service not available");
        }
        if (this.ps.isProfileEnable(profileId)) {
            throw new ConflictingOperationException("Cannot change profile data.  Profile must be disabled");
        }
        SimpleProperties properties = new SimpleProperties();
        try {
            properties.load((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            throw new BadRequestException("Could not parse raw profile data.", (Throwable)e);
        }
        properties.remove((Object)"profileId");
        properties.remove((Object)"classId");
        try {
            Profile tempProfile;
            Profile profile = this.ps.getProfile(profileId);
            if (profile == null) {
                throw new ProfileNotFoundException(profileId);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            properties.store((OutputStream)out, null);
            data = out.toByteArray();
            String classId = this.ps.getProfileClassId(profileId);
            String className = this.registry.getPluginInfo("profile", classId).getClassName();
            try {
                tempProfile = (Profile)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PKIException("Error instantiating profile class: " + className);
            }
            tempProfile.setId(profileId);
            try {
                ProfileConfig profileConfig = new ProfileConfig();
                profileConfig.load(new ByteArrayInputStream(data));
                tempProfile.init(this.engineConfig, this.registry, profileConfig);
            }
            catch (Exception e) {
                throw new BadRequestException("Invalid profile data", (Throwable)e);
            }
            profile.getConfigStore().clear();
            profile.getConfigStore().load(new ByteArrayInputStream(data));
            this.ps.disableProfile(profileId);
            this.ps.commitProfile(profileId);
            return this.createOKResponse(data);
        }
        catch (EBaseException | IOException e) {
            logger.error("modifyProfile: error modifying profile " + profileId + ": " + e.getMessage(), e);
            throw new PKIException("Error modifying profile.", e);
        }
    }

    private void changeProfileData(ProfileData data, Profile profile) throws Exception {
        String profileId = data.getId();
        if (profile == null) {
            logger.error("changeProfileData - profile is null");
            throw new PKIException("Error changing profile data. Profile not available.");
        }
        if (this.ps.isProfileEnable(profileId)) {
            throw new ConflictingOperationException("Cannot change profile data.  Profile must be disabled");
        }
        LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
        if (this.differs(profile.getAuthenticatorId(), data.getAuthenticatorId())) {
            profile.setAuthenticatorId(data.getAuthenticatorId());
            auditParams.put("authenticatorId", data.getAuthenticatorId());
        }
        if (this.differs(profile.getAuthzAcl(), data.getAuthzAcl())) {
            profile.setAuthzAcl(data.getAuthzAcl());
            auditParams.put("authzAcl", data.getAuthzAcl());
        }
        if (this.differs(profile.getDescription(this.getLocale(this.headers)), data.getDescription())) {
            profile.setDescription(this.getLocale(this.headers), data.getDescription());
            auditParams.put("description", data.getDescription());
        }
        if (this.differs(profile.getId(), data.getId())) {
            profile.setId(data.getId());
            auditParams.put("id", data.getId());
        }
        if (this.differs(profile.getName(this.getLocale(this.headers)), data.getName())) {
            profile.setName(this.getLocale(this.headers), data.getName());
            auditParams.put("name", data.getName());
        }
        if (this.differs(profile.isRenewal(), Boolean.toString(data.isRenewal()))) {
            profile.setRenewal(data.isRenewal());
            auditParams.put("renewal", Boolean.toString(data.isRenewal()));
        }
        if (!profile.isVisible() == data.isVisible()) {
            profile.setVisible(data.isVisible());
            auditParams.put("visible", Boolean.toString(data.isVisible()));
        }
        if (this.differs(profile.isXmlOutput(), Boolean.toString(data.isXMLOutput()))) {
            profile.setXMLOutput(data.isXMLOutput());
            auditParams.put("xmloutput", Boolean.toString(data.isXMLOutput()));
        }
        if (!auditParams.isEmpty()) {
            this.auditProfileChange("rules", "OP_MODIFY", profileId, "Success", auditParams);
        }
        try {
            this.populateProfileInputs(data, profile);
            this.populateProfileOutputs(data, profile);
            this.populateProfilePolicies(data, profile);
            this.ps.commitProfile(profileId);
        }
        catch (EBaseException e) {
            logger.error("ProfileService: Unable to update profile: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to update profile: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean differs(String v1, String v2) {
        return v1 != null ? !v1.equals(v2) : v2 != null;
    }

    private void populateProfilePolicies(ProfileData data, Profile profile) throws EBaseException {
        ArrayList<CallSite> auditAdd = new ArrayList<CallSite>();
        ArrayList<CallSite> auditModify = new ArrayList<CallSite>();
        Enumeration<String> existingSetIds = profile.getProfilePolicySetIds();
        LinkedHashMap<CallSite, com.netscape.certsrv.profile.ProfilePolicy> existingPolicies = new LinkedHashMap<CallSite, com.netscape.certsrv.profile.ProfilePolicy>();
        while (existingSetIds.hasMoreElements()) {
            String setId = existingSetIds.nextElement();
            Enumeration<String> enumeration = profile.getProfilePolicyIds(setId);
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                existingPolicies.put((CallSite)((Object)((String)setId + ":" + string)), this.createProfilePolicy(profile, setId, string));
            }
        }
        for (Map.Entry entry : data.getPolicySets().entrySet()) {
            String string = (String)entry.getKey();
            for (com.netscape.certsrv.profile.ProfilePolicy policy : (List)entry.getValue()) {
                String id = string + ":" + policy.getId();
                if (!existingPolicies.containsKey(id)) {
                    auditAdd.add((CallSite)((Object)id));
                } else if (!policy.equals(existingPolicies.get(id))) {
                    auditModify.add((CallSite)((Object)id));
                }
                existingPolicies.remove(id);
            }
        }
        ArrayList auditDelete = new ArrayList(existingPolicies.keySet());
        try {
            profile.deleteAllProfilePolicies();
            for (Map.Entry entry : data.getPolicySets().entrySet()) {
                String setId = (String)entry.getKey();
                for (com.netscape.certsrv.profile.ProfilePolicy policy : (List)entry.getValue()) {
                    PolicyDefault def = policy.getDef();
                    PolicyConstraint con = policy.getConstraint();
                    ProfilePolicy p = profile.createProfilePolicy(setId, policy.getId(), def.getClassId(), con.getClassId());
                    ProfilePoliciesConfig policiesConfig = profile.getConfigStore().getPoliciesConfig();
                    ConfigStore pstore = policiesConfig.getSubStore(setId + "." + policy.getId(), ConfigStore.class);
                    if (!def.getName().isEmpty()) {
                        pstore.putString("default.name", def.getName());
                    }
                    for (ProfileParameter param : def.getParams()) {
                        if (param.getValue().isEmpty()) continue;
                        p.getDefault().setConfig(param.getName(), param.getValue());
                    }
                    if (!con.getName().isEmpty()) {
                        pstore.putString("constraint.name", con.getName());
                    }
                    for (PolicyConstraintValue pcv : con.getConstraints()) {
                        if (pcv.getValue().isEmpty()) continue;
                        p.getConstraint().setConfig(pcv.getName(), pcv.getValue());
                    }
                }
            }
            if (!auditDelete.isEmpty()) {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("inputs", StringUtils.join(auditDelete, (String)","));
                this.auditProfileChange("policies", "OP_DELETE", profile.getId(), "Success", linkedHashMap);
            }
            if (!auditAdd.isEmpty()) {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("inputs", StringUtils.join(auditAdd, (String)","));
                this.auditProfileChange("policies", "OP_ADD", profile.getId(), "Success", linkedHashMap);
            }
            if (!auditModify.isEmpty()) {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("inputs", StringUtils.join(auditModify, (String)","));
                this.auditProfileChange("policies", "OP_MODIFY", profile.getId(), "Success", linkedHashMap);
            }
        }
        catch (EProfileException | EPropertyException throwable) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("added", StringUtils.join(auditAdd, (String)","));
            linkedHashMap.put("deleted", StringUtils.join(auditDelete, (String)","));
            linkedHashMap.put("modified", StringUtils.join(auditModify, (String)","));
            this.auditProfileChange("policies", "OP_MODIFY", profile.getId(), "Failure", linkedHashMap);
            throw throwable;
        }
    }

    private void populateProfileOutputs(ProfileData data, Profile profile) throws EBaseException {
        ArrayList<String> auditAdd = new ArrayList<String>();
        ArrayList<String> auditModify = new ArrayList<String>();
        Enumeration<String> existingIds = profile.getProfileOutputIds();
        LinkedHashMap<String, ProfileOutput> existingOutputs = new LinkedHashMap<String, ProfileOutput>();
        while (existingIds.hasMoreElements()) {
            String id = existingIds.nextElement();
            ProfileOutput output = ProfileService.createProfileOutput(profile, id, this.getLocale(this.headers));
            if (output == null) continue;
            existingOutputs.put(id, output);
        }
        List outputs = data.getOutputs();
        for (Object output : outputs) {
            String id = output.getId();
            if (!existingOutputs.containsKey(id)) {
                auditAdd.add(id);
                continue;
            }
            if (!output.equals(existingOutputs.get(id))) {
                auditModify.add(id);
            }
            existingOutputs.remove(id);
        }
        ArrayList auditDelete = new ArrayList(existingOutputs.keySet());
        try {
            LinkedHashMap<String, String> auditParams;
            profile.deleteAllProfileOutputs();
            for (ProfileOutput output : outputs) {
                String id = output.getId();
                String classId = output.getClassId();
                NameValuePairs nvp = new NameValuePairs();
                profile.createProfileOutput(id, classId, nvp);
            }
            if (!auditDelete.isEmpty()) {
                auditParams = new LinkedHashMap<String, String>();
                auditParams.put("outputs", StringUtils.join(auditDelete, (String)","));
                this.auditProfileChange("profileOutput", "OP_DELETE", profile.getId(), "Success", auditParams);
            }
            if (!auditAdd.isEmpty()) {
                auditParams = new LinkedHashMap();
                auditParams.put("outputs", StringUtils.join(auditAdd, (String)","));
                this.auditProfileChange("profileOutput", "OP_ADD", profile.getId(), "Success", auditParams);
            }
            if (!auditModify.isEmpty()) {
                auditParams = new LinkedHashMap();
                auditParams.put("outputs", StringUtils.join(auditModify, (String)","));
                this.auditProfileChange("profileOutput", "OP_MODIFY", profile.getId(), "Success", auditParams);
            }
        }
        catch (EProfileException e) {
            LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
            auditParams.put("added", StringUtils.join(auditAdd, (String)","));
            auditParams.put("deleted", StringUtils.join(auditDelete, (String)","));
            auditParams.put("modified", StringUtils.join(auditModify, (String)","));
            this.auditProfileChange("profileOutput", "OP_MODIFY", profile.getId(), "Failure", auditParams);
            throw e;
        }
    }

    private void populateProfileInputs(ProfileData data, Profile profile) throws EBaseException {
        ArrayList<String> auditAdd = new ArrayList<String>();
        ArrayList<String> auditModify = new ArrayList<String>();
        Enumeration<String> existingIds = profile.getProfileInputIds();
        LinkedHashMap<String, ProfileInput> existingInputs = new LinkedHashMap<String, ProfileInput>();
        while (existingIds.hasMoreElements()) {
            String id = existingIds.nextElement();
            ProfileInput input = ProfileService.createProfileInput(profile, id, this.getLocale(this.headers));
            if (input == null) continue;
            existingInputs.put(id, input);
        }
        List inputs = data.getInputs();
        for (Object input : inputs) {
            String id = input.getId();
            if (!existingInputs.containsKey(id)) {
                auditAdd.add(id);
                continue;
            }
            if (!input.equals(existingInputs.get(id))) {
                auditModify.add(id);
            }
            existingInputs.remove(id);
        }
        ArrayList auditDelete = new ArrayList(existingInputs.keySet());
        try {
            LinkedHashMap<String, String> auditParams;
            profile.deleteAllProfileInputs();
            for (ProfileInput input : inputs) {
                String id = input.getId();
                String classId = input.getClassId();
                NameValuePairs nvp = new NameValuePairs();
                profile.createProfileInput(id, classId, nvp);
            }
            if (!auditDelete.isEmpty()) {
                auditParams = new LinkedHashMap<String, String>();
                auditParams.put("inputs", StringUtils.join(auditDelete, (String)","));
                this.auditProfileChange("profileInput", "OP_DELETE", profile.getId(), "Success", auditParams);
            }
            if (!auditAdd.isEmpty()) {
                auditParams = new LinkedHashMap();
                auditParams.put("inputs", StringUtils.join(auditAdd, (String)","));
                this.auditProfileChange("profileInput", "OP_ADD", profile.getId(), "Success", auditParams);
            }
            if (!auditModify.isEmpty()) {
                auditParams = new LinkedHashMap();
                auditParams.put("inputs", StringUtils.join(auditModify, (String)","));
                this.auditProfileChange("profileInput", "OP_MODIFY", profile.getId(), "Success", auditParams);
            }
        }
        catch (EProfileException e) {
            LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
            auditParams.put("added", StringUtils.join(auditAdd, (String)","));
            auditParams.put("deleted", StringUtils.join(auditDelete, (String)","));
            auditParams.put("modified", StringUtils.join(auditModify, (String)","));
            this.auditProfileChange("profileInput", "OP_MODIFY", profile.getId(), "Failure", auditParams);
            throw e;
        }
    }

    public Response deleteProfile(@PathParam(value="id") String profileId) {
        if (profileId == null) {
            logger.error("deleteProfile: invalid request. profileId is null");
            throw new BadRequestException("Unable to delete profile: Invalid Profile Id");
        }
        if (this.ps == null) {
            logger.error("deleteProfile: ps is null");
            throw new PKIException("Error deleting profile.  Profile Service not available");
        }
        try {
            Profile profile = this.ps.getProfile(profileId);
            if (profile == null) {
                logger.error("Trying to delete profile: " + profileId + ".  Profile already deleted.");
                throw new ProfileNotFoundException(profileId);
            }
            if (this.ps.isProfileEnable(profileId)) {
                logger.error("Delete profile not permitted.  Profile must be disabled first.");
                this.auditProfileChange("rules", "OP_DELETE", profileId, "Failure", null);
                throw new ConflictingOperationException("Cannot delete profile `" + profileId + "`.  Profile must be disabled first.");
            }
            this.ps.deleteProfile(profileId);
            this.auditProfileChange("rules", "OP_DELETE", profileId, "Failure", null);
            return this.createNoContentResponse();
        }
        catch (EBaseException e) {
            logger.error("deleteProfile: error in deleting profile `" + profileId + "`: " + e.getMessage(), (Throwable)e);
            this.auditProfileChange("rules", "OP_DELETE", profileId, "Failure", null);
            throw new PKIException("Error deleting profile.");
        }
    }

    public void auditProfileChangeState(String profileId, String op, String status) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditor.getSubjectID(), status, profileId, op});
        auditor.log(msg);
    }

    public void auditProfileChange(String scope, String type, String id, String status, Map<String, String> params) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditor.getSubjectID(), status, auditor.getParamString(scope, type, id, params)});
        auditor.log(msg);
    }
}

