/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.acme;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.acme.ACMECLI;
import com.netscape.cmstools.cli.MainCLI;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.acme.ACMEClient;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.util.logging.PKILogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACMEEnableCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ACMEEnableCLI.class);

    public ACMEEnableCLI(ACMECLI acmeCLI) {
        super("enable", "Enable ACME service", (CLI)acmeCLI);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    public void execute(CommandLine cmd) throws Exception {
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = mainCLI.getClient();
        ACMEClient acmeClient = new ACMEClient(client);
        acmeClient.login();
        logger.info("Enabling ACME service");
        acmeClient.enable();
        acmeClient.logout();
    }
}

