/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.authority;

import com.netscape.cmstools.authority.AuthorityCLI;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.PublicKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class AuthorityKeyExportCLI
extends CommandCLI {
    public AuthorityCLI authorityCLI;
    private OBJECT_IDENTIFIER DES_EDE3_CBC_OID = new OBJECT_IDENTIFIER("1.2.840.113549.3.7");
    private OBJECT_IDENTIFIER AES_128_CBC_OID = new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.1.2");

    public AuthorityKeyExportCLI(AuthorityCLI authorityCLI) {
        super("key-export", "Export wrapped CA signing key", (CLI)authorityCLI);
        this.authorityCLI = authorityCLI;
    }

    public void createOptions() {
        Option option = new Option("o", "output", true, "Output file");
        option.setArgName("filename");
        this.options.addOption(option);
        option = new Option(null, "wrap-nickname", true, "Nickname of wrapping key");
        option.setArgName("nickname");
        this.options.addOption(option);
        option = new Option(null, "target-nickname", true, "Nickname of target key");
        option.setArgName("nickname");
        this.options.addOption(option);
        option = new Option(null, "algorithm", true, "Symmetric encryption algorithm");
        option.setArgName("OID");
        this.options.addOption(option);
        option = new Option(null, "oaep", false, "Use RSA OAEP key wrap algorithm");
        this.options.addOption(option);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " --wrap-nickname NICKNAME --target-nickname NICKNAME -o FILENAME [--algorithm OID]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String filename = cmd.getOptionValue("output");
        if (filename == null) {
            throw new Exception("No output file specified.");
        }
        String wrapNick = cmd.getOptionValue("wrap-nickname");
        if (wrapNick == null) {
            throw new Exception("No wrapping key nickname specified.");
        }
        String targetNick = cmd.getOptionValue("target-nickname");
        if (targetNick == null) {
            throw new Exception("No target key nickname specified.");
        }
        boolean useOAEP = false;
        if (cmd.hasOption("oaep")) {
            useOAEP = true;
        }
        OBJECT_IDENTIFIER algOid = this.DES_EDE3_CBC_OID;
        String algOidString = cmd.getOptionValue("algorithm");
        if (algOidString != null) {
            algOid = new OBJECT_IDENTIFIER(algOidString);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CryptoManager cm = CryptoManager.getInstance();
        X509Certificate wrapCert = cm.findCertByNickname(wrapNick);
        X509Certificate targetCert = cm.findCertByNickname(targetNick);
        PublicKey wrappingKey = wrapCert.getPublicKey();
        PrivateKey toBeWrapped = cm.findPrivKeyByCert(targetCert);
        CryptoToken token = cm.getInternalKeyStorageToken();
        AlgorithmIdentifier aid = null;
        WrappingParams params = null;
        KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
        if (useOAEP) {
            wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
        }
        if (algOid.equals((Object)this.DES_EDE3_CBC_OID)) {
            encAlg = EncryptionAlgorithm.DES3_CBC_PAD;
            iv = CryptoUtil.getNonceData((int)encAlg.getIVLength());
            ivps = new IVParameterSpec(iv);
            params = new WrappingParams(SymmetricKey.DES3, KeyGenAlgorithm.DES3, 168, wrapAlg, encAlg, KeyWrapAlgorithm.DES3_CBC_PAD, ivps, ivps);
            aid = new AlgorithmIdentifier(algOid, (ASN1Value)new OCTET_STRING(iv));
        } else if (algOid.equals((Object)this.AES_128_CBC_OID)) {
            encAlg = EncryptionAlgorithm.AES_CBC_PAD;
            iv = CryptoUtil.getNonceData((int)encAlg.getIVLength());
            ivps = new IVParameterSpec(iv);
            params = new WrappingParams(SymmetricKey.AES, KeyGenAlgorithm.AES, 128, wrapAlg, encAlg, KeyWrapAlgorithm.AES_CBC_PAD, ivps, ivps);
            aid = new AlgorithmIdentifier(algOid, (ASN1Value)new OCTET_STRING(iv));
        } else {
            throw new Exception("Unsupported algorithm: " + algOid.toString());
        }
        byte[] data = CryptoUtil.createEncodedPKIArchiveOptions((CryptoToken)token, (PublicKey)wrappingKey, (PrivateKey)toBeWrapped, (WrappingParams)params, (AlgorithmIdentifier)aid);
        try (OutputStream os = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            os.write(data);
        }
    }
}

